% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-cyclical.R
\docType{data}
\name{scale_cyclical}
\alias{scale_colour_cyclical}
\alias{scale_color_cyclical}
\alias{scale_fill_cyclical}
\alias{scale_alpha_cyclical}
\alias{scale_linetype_cyclical}
\alias{scale_size_cyclical}
\alias{cyclical_scale}
\alias{ScaleCyclical}
\title{Create a discrete scale that cycles between values}
\usage{
scale_colour_cyclical(..., values)

scale_fill_cyclical(..., values)

scale_alpha_cyclical(..., values)

scale_linetype_cyclical(..., values)

scale_size_cyclical(..., values)
}
\arguments{
\item{...}{Common discrete scale parameters: \code{name}, \code{breaks}, \code{labels}, \code{na.value}, \code{limits} and \code{guide}.
See \code{\link{discrete_scale}} for more details.}

\item{values}{The aesthetic values that the scale should cycle through, e.g. colors if it is
a scale for the color or fill aesthetic.}
}
\description{
The readability of joyplots can often be improved by alternating between fill colors and
other aesthetics. The various cyclical scales make it easy to create plots with this feature,
simply map your grouping variable to the respective aesthetic (e.g., \code{fill}) and then use
\code{scale_fill_cyclical} to define the fill colors between you want to alternate. Note that the
cyclical scales do not draw legends by default, because the legends will usually be wrong
unless the labels are properly adjusted. To draw legends, set the \code{guide} argument to \code{"legend"},
as shown in the examples.
}
\examples{
# By default, scale_cyclical sets `guide = "none"`, i.e., no legend
# is drawn
ggplot(diamonds, aes(x = price, y = cut, fill = cut)) +
  geom_joy(scale = 4) +
  scale_fill_cyclical(values = c("#3030D0", "#9090F0"))

# However, legends can be turned on by setting `guide = "legend"`
ggplot(diamonds, aes(x = price, y = cut, fill = cut)) +
  geom_joy(scale = 4) +
  scale_fill_cyclical(values = c("#3030D0", "#9090F0"),
                      guide = "legend", name = "Fill colors",
                      labels = c("dark blue", "light blue"))

# Cyclical scales are also available for the various other aesthetics
ggplot(diamonds, aes(x = price, y = cut, fill = cut,
                     color = cut, size = cut,
                     alpha = cut, linetype = cut)) +
  geom_joy(scale = 4, fill = "blue") +
  scale_fill_cyclical(values = c("blue", "green")) +
  scale_color_cyclical(values = c("black", "white")) +
  scale_size_cyclical(values = c(2, 1)) +
  scale_alpha_cyclical(values = c(0.4, 0.8)) +
  scale_linetype_cyclical(values = c(1, 2))

}
\keyword{datasets}
