% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aes.wrangle.R
\name{aes_eval}
\alias{aes_eval}
\title{Assign inputs to \code{x}, \code{y} or \code{dots}.}
\usage{
aes_eval(vars, x, y, dots)
}
\arguments{
\item{vars, x, y, dots}{Arguments passed from \code{aes_loop()} or
\code{aes_loop2()}.}
}
\value{
The list returned by \code{aes_eval()} is the input for the remapping
functions.

The logical vector \code{$is.dots} is placed between the \code{x} and
\code{y} vectors (if any) and the \code{dots} vectors (if any). This is used
for easy reference in \code{if} statements.

The length of each vector (\code{x}, \code{y}, and \code{dots}) in the output
list is determined by the length of the vector passed to \code{aes_loop()}.
If an \code{x} or \code{y} variable is passed more than once, then it will be
present in the vector the same number of times it was passed into
\code{aes_loop()}.
}
\description{
\code{aes_eval()} figures out which variables have been passed and
appropriatley assigns the variables to their respective mapping: either
(\code{x}, \code{y}, or \code{dots}). Furthermore, it distinguishes between
ggplot-like syntax and dplyr-like syntax calling of variables.
}
\details{
\code{aes_eval()} is the first major function to be called by
\code{aes_loop()}.
}
\seealso{
Source for \code{names_list} and code structure of \code{lazyeval::} function
calls can be found at
\href{https://github.com/hadley/dplyr/blob/master/R/select-utils.R}{~/dplyr/R/select-vars.R}
and
\href{https://github.com/hadley/dplyr/blob/master/R/select-utils.R}{~/dplyr/R/select-utils.R}.
}

