\name{RepMarDAG}
\alias{RepMarDAG}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Representational Markov equivalence to directed acyclic graphs.
}
\description{
\code{RepMarDAG} determines whether a given maximal ancestral graph can 
be Markov equivalent to a directed acyclic graph, and if that is the case, 
it finds a directed acyclic graph that is Markov equivalent to the given 
graph.}
\usage{
RepMarDAG(amat)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{amat}{
An adjacency matrix, or a graph that can be a \code{graphNEL} or an \code{\link{igraph}} object 
or a vector of length \eqn{3e}, where \eqn{e} is the number of edges of the graph, 
that is a sequence of triples (type, node1label, node2label). The type 
of edge can be \code{"a"} (arrows from node1 to node2), \code{"b"} (arcs), and 
\code{"l"} (lines).
}
}
\details{
\code{RepMarDAG} first looks whether the subgraph induced by full lines
is chordal and whether there is a minimal collider path or cycle of
length 4 in graph.}
\value{
Either "NOT Markov equivalent to a DAG" or a matrix that is the 
adjacency matrix of the generated graph.
It consists of 4 different integers as an \eqn{ij}-element: 0 for a missing 
edge between \eqn{i} and \eqn{j}, 1 for an arrow from \eqn{i} to \eqn{j}, 10 for a full line between 
\eqn{i} and \eqn{j}, and 100 for a bi-directed arrow between \eqn{i} and \eqn{j}. These numbers are 
added to be associated with multiple edges of different types. The matrix is 
symmetric w.r.t full lines and bi-directed arrows.
}
\references{
Sadeghi, K. (2011). Markov equivalences for subclasses of loopless mixed graphs.
\emph{Submitted}, 2011. }
\author{
Kayvan Sadeghi
}
%\note{
%%  ~~further notes~~
%}

\seealso{
\code{\link{MarkEqMag}}, \code{\link{MarkEqRcg}}, \code{\link{RepMarBG}},
\code{\link{RepMarUG}}}
\examples{
H<-matrix(c(0,10,0,0,10,0,0,0,0,1,0,100,0,0,100,0),4,4)
RepMarBG(H)
}
\keyword{graphs}
\keyword{bidirected graph}
\keyword{Markov equivalence}
\keyword{maximal ancestral graph}
\keyword{representational Markov equivalence}
