% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_to_inset.R
\name{transform_to_inset}
\alias{transform_to_inset}
\title{Transform coordinates according to inset configuration}
\usage{
transform_to_inset(x, inset)
}
\arguments{
\item{x}{Spatial data frame or other sf object; see \code{\link[sf:st_geometry]{sf::st_geometry()}}.}

\item{inset}{Inset configuration; see \code{\link[=configure_inset]{configure_inset()}}.}
}
\value{
A copy of \code{x} with the geometry replaced by the transformed version.
}
\description{
This helper operates on an sf object to scale and translate its geometry according
to the inset specification.
}
\examples{
library(sf)

nc <- sf::st_read(system.file("shape/nc.shp", package = "sf"), quiet = TRUE)
cfg <- configure_inset(
  centre = st_sfc(st_point(c(-82, 35)), crs = 4326),
  scale = 2,
  translation = c(10, -60),
  radius = 50,
  units = "mi")

transform_to_inset(nc, cfg)
}
