##'  Assigning colors to sequence alignment.
##'
##'
##' @param y sequence alignment with data frame, generated by tidy_msa().
##' @param color a Color scheme. One of 'Clustal', 'Chemistry_AA', 'Shapely_AA', 'Zappo_AA', 'Taylor_AA', 'LETTER', 'CN6', 'Chemistry_NT', 'Shapely_NT', 'Zappo_NT', 'Taylor_NT'. Defaults is 'Chemistry_AA'.

color_scheme <- function(y, color) {
    if(grepl("NT", color)){
        y$color <- scheme_NT[y$character, color]
    } else{
        y$color <- scheme_AA[y$character, color]
    }
  return(y)
}




