% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord-serialaxes.R
\name{coord_serialaxes}
\alias{coord_serialaxes}
\title{Serial axes coordinates}
\usage{
coord_serialaxes(
  axes.layout = c("parallel", "radial"),
  scaling = c("variable", "observation", "data", "none"),
  axes.sequence = character(0L),
  positive = TRUE,
  ...
)
}
\arguments{
\item{axes.layout}{Serial axes layout, either "parallel" or "radial".}

\item{scaling}{One of 'variable', 'data', 'observation' or 'none' to specify how the data is scaled.}

\item{axes.sequence}{A vector with variable names that defines the axes sequence.}

\item{positive}{If `y` is set as the density estimate, where the smoothed curved is faced to,
right (`positive`) or left (`negative`) as vertical layout;
up (`positive`) or down (`negative`) as horizontal layout?}

\item{...}{other arguments used to modify layers}
}
\description{
It is mainly used to visualize the high dimensional data set
either on the parallel coordinate or the radial coordinate.
}
\details{
Serial axes coordinate system (parallel or radial) is different from the
Cartesian coordinate system or its transformed system (say \code{polar} in \code{ggplot2})
since it does not have a formal transformation
(i.e. in polar coordinate system, "x = rcos(theta)", "y = rsin(theta)").
In serial axes coordinate system, mapping aesthetics does not really require "x" or "y". Any "non-aesthetics"
components passed in the `mapping` system will be treated as an individual axis.

To project a common \code{geom} layer on such serialaxes,
users can customize function \code{\link{add_serialaxes_layers}}.
}
\examples{
# set sequence by `axes.sequence`
p <- ggplot(iris) +
       geom_path(alpha = 0.2) +
       coord_serialaxes(axes.sequence = colnames(iris))
# an 'iris' parallel coordinate plot.
p
# histogram layer (parallel coord)
p + geom_histogram(alpha = 0.8, mapping = aes(fill = Species))
# density layer
p + geom_density(alpha = 0.8)
# quantile layer
p + geom_quantiles(alpha = 0.8, colour = "red", size = 2)

# radial axes
# set sequence in `mapping`
ggplot(iris,
       mapping = aes(
         Sepal.Length = Sepal.Length,
         Sepal.Width = Sepal.Width,
         Petal.Length = Petal.Length,
         Petal.Width = Petal.Width,
         colour = Species
       )) +
       geom_path() +
       coord_serialaxes(axes.layout = "radial")

}
