% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-hist-.R, R/stat-hist-.R
\name{geom_hist_}
\alias{geom_hist_}
\alias{geom_histogram_}
\alias{geom_bar_}
\alias{stat_hist_}
\alias{stat_bin_}
\alias{stat_count_}
\title{More general histogram}
\usage{
geom_hist_(
  mapping = NULL,
  data = NULL,
  stat = "hist_",
  position = "stack_",
  ...,
  scale.x = NULL,
  scale.y = c("data", "group", "variable"),
  as.mix = FALSE,
  binwidth = NULL,
  bins = NULL,
  positive = TRUE,
  prop = 0.9,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_histogram_(
  mapping = NULL,
  data = NULL,
  stat = "bin_",
  position = "stack_",
  ...,
  scale.x = NULL,
  scale.y = c("data", "group"),
  as.mix = FALSE,
  positive = TRUE,
  prop = 0.9,
  binwidth = NULL,
  bins = NULL,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_bar_(
  mapping = NULL,
  data = NULL,
  stat = "count_",
  position = "stack_",
  ...,
  scale.x = NULL,
  scale.y = c("data", "group"),
  positive = TRUE,
  prop = 0.9,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_hist_(
  mapping = NULL,
  data = NULL,
  geom = "bar_",
  position = "stack_",
  ...,
  binwidth = NULL,
  bins = NULL,
  center = NULL,
  boundary = NULL,
  breaks = NULL,
  closed = c("right", "left"),
  pad = FALSE,
  width = NULL,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_bin_(
  mapping = NULL,
  data = NULL,
  geom = "bar_",
  position = "stack_",
  ...,
  binwidth = NULL,
  bins = NULL,
  center = NULL,
  boundary = NULL,
  breaks = NULL,
  closed = c("right", "left"),
  pad = FALSE,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_count_(
  mapping = NULL,
  data = NULL,
  geom = "bar_",
  position = "stack_",
  ...,
  width = NULL,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{position}{Position adjustment, either as a string, or the result of a call to a position adjustment function.
Function \code{geom_hist_} and \code{geom_histogram_} understand \code{stack_} (stacks bars on top of each other),
or \code{dodge_} and \code{dodge2_} (overlapping objects side-to-side) instead of \code{stack}, \code{dodge} or \code{dodge2}}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{scale.x}{A sorted length 2 numerical vector representing
the range of the whole data will be scaled to. The default value is (0, 1).}

\item{scale.y}{one of \code{data} and \code{group} to specify.
\tabular{ll}{ \strong{Type} \tab \strong{Description}
\cr data (default) \tab The density estimates are scaled by the whole data set
\cr group \tab The density estimates are scaled by each group
}
If the \code{scale.y} is \code{data}, it is meaningful to compare the density (shape and area) across all groups; else
it is only meaningful to compare the density within each group. See details.}

\item{as.mix}{Logical. Within each group, if \code{TRUE}, the sum of the density estimate area is mixed and
scaled to maximum 1. The area of each subgroup (in general, within each group one color represents one subgroup)
is proportional to the count; if \code{FALSE} the area of each subgroup is the same, with maximum 1. See details.}

\item{binwidth}{The width of the bins. Can be specified as a numeric value
or as a function that calculates width from unscaled x. Here, "unscaled x"
refers to the original x values in the data, before application of any
scale transformation. When specifying a function along with a grouping
structure, the function will be called once per group.
The default is to use the number of bins in \code{bins},
covering the range of the data. You should always override
this value, exploring multiple widths to find the best to illustrate the
stories in your data.

The bin width of a date variable is the number of days in each time; the
bin width of a time variable is the number of seconds.}

\item{bins}{Number of bins. Overridden by \code{binwidth}. Defaults to 30.}

\item{positive}{If \code{y} is set as the density estimate, where the smoothed curved is faced to,
right (`positive`) or left (`negative`) as vertical layout; up (`positive`) or down (`negative`) as horizontal layout?}

\item{prop}{adjust the proportional maximum height of the estimate (density, histogram, ...).}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{orientation}{The orientation of the layer. The default (\code{NA})
automatically determines the orientation from the aesthetic mapping. In the
rare event that this fails it can be given explicitly by setting \code{orientation}
to either \code{"x"} or \code{"y"}. See the \emph{Orientation} section for more detail.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{geom, stat}{Use to override the default connection between geom_hist_()/geom_histogram_()/geom_bar_() and
stat_hist_()/stat_bin_()/stat_count_().}

\item{center, boundary}{bin position specifiers. Only one, \code{center} or
\code{boundary}, may be specified for a single plot. \code{center} specifies the
center of one of the bins. \code{boundary} specifies the boundary between two
bins. Note that if either is above or below the range of the data, things
will be shifted by the appropriate integer multiple of \code{binwidth}.
For example, to center on integers use \code{binwidth = 1} and \code{center = 0}, even
if \code{0} is outside the range of the data. Alternatively, this same alignment
can be specified with \code{binwidth = 1} and \code{boundary = 0.5}, even if \code{0.5} is
outside the range of the data.}

\item{breaks}{Alternatively, you can supply a numeric vector giving
the bin boundaries. Overrides \code{binwidth}, \code{bins}, \code{center},
and \code{boundary}.}

\item{closed}{One of \code{"right"} or \code{"left"} indicating whether right
or left edges of bins are included in the bin.}

\item{pad}{If \code{TRUE}, adds empty bins at either end of x. This ensures
frequency polygons touch 0. Defaults to \code{FALSE}.}

\item{width}{Bar width. By default, set to 90\% of the resolution of the data.}
}
\description{
More general histogram (\code{geom_histogram}) or bar plot (\code{geom_bar}).
Both \code{x} and \code{y} could be accommodated. See details
}
\details{
\code{x} (or \code{y}) is a group variable (categorical) and \code{y} (or \code{x}) a target variable (numerical) to be plotted.
If only one of \code{x} or \code{y} is provided, it will treated as a target variable and
\code{ggplot2::geom_histogram} will be executed. Several things should be noticed:

1. If both \code{x} and \code{y} are given, they can be one discrete one continuous or
two discrete. But they cannot be two continuous variables (which one will be considered as a group variable?).

2. \code{geom_hist_} is a wrapper of \code{geom_histogram_} and \code{geom_count_}.
Suppose the \code{y} is our interest (\code{x} is the categorical variable),
\code{geom_hist_()} can accommodate either continuous or discrete \code{y}. While,
\code{geom_histogram_()} only accommodates the continuous \code{y} and
\code{geom_bar_()} only accommodates the discrete \code{y}.

3. There are four combinations of \code{scale.y} and \code{as.mix}.
\describe{
  \item{\code{scale.y} = "group" and \code{as.mix} = FALSE}{The density estimate area of each subgroup (represented by each color)
  within the same group is the same.}
  \item{\code{scale.y} = "group" and \code{as.mix} = TRUE}{The density estimate area of each subgroup (represented by each color)
  within the same group is proportional to its own counts.}
  \item{\code{scale.y} = "data" and \code{as.mix} = FALSE}{The sum of density estimate area of all groups is scaled to maximum of 1.
  and the density area for each group is proportional to the its count. Within each group, the area of each subgroup is the same.}
  \item{\code{scale.y} = "data" and \code{as.mix} = TRUE}{The sum of density estimate area of all groups is scaled to maximum of 1
  and the area of each subgroup (represented by each color) is proportional to its own count.}
}
See vignettes[https://great-northern-diver.github.io/ggmulti/articles/histogram-density-.html] for more intuitive explanation.
Note that, if it is a grouped bar chart (both \code{x} and \code{y} are categorical),
parameter `as.mix` is meaningless.
}
\section{Orientation}{
 
This geom treats each axis differently and, thus, can thus have two orientations. Often the orientation is easy to deduce from a combination of the given mappings and the types of positional scales in use. Thus, ggplot2 will by default try to guess which orientation the layer should have. Under rare circumstances, the orientation is ambiguous and guessing may fail. In that case the orientation can be specified directly using the \code{orientation} parameter, which can be either \code{"x"} or \code{"y"}. The value gives the axis that the geom should run along, \code{"x"} being the default orientation you would expect for the geom.
}

\examples{
if(require(dplyr) && require(tidyr)) {

  # histogram
  p0 <- mpg \%>\%
    dplyr::filter(manufacturer \%in\% c("dodge", "ford", "toyota", "volkswagen")) \%>\%
    ggplot(mapping = aes(x = manufacturer, y = cty))
  p0 + geom_hist_()

  ## set position
  #### default is "stack_"
  p0 + geom_hist_(mapping = aes(fill = fl))
  #### "dodge_"
  p0 + geom_hist_(position = "dodge_",
                  mapping = aes(fill = fl))
  #### "dodge2_"
  p0 + geom_hist_(position = "dodge2_",
                  mapping = aes(fill = fl))

  # bar chart
  mpg \%>\%
    ggplot(mapping = aes(x = drv, y = class)) +
    geom_hist_(orientation = "y")

  # scale.y as "group"
  p <- iris \%>\%
    tidyr::pivot_longer(cols = -Species,
                        names_to = "Outer sterile whorls",
                        values_to = "x") \%>\%
    ggplot(mapping = aes(x = `Outer sterile whorls`,
                         y = x, fill = Species)) +
    stat_hist_(scale.y = "group",
               prop = 0.6,
               alpha = 0.5)
  p
  # with density on the left
  p + stat_density_(scale.y = "group",
                    prop = 0.6,
                    alpha = 0.5,
                    positive = FALSE)

  ########### only `x` or `y` is provided ###########
  # that would be equivalent to call function
  # `geom_histogram()` or `geom_bar()`
  ### histogram
  diamonds \%>\%
    dplyr::sample_n(500) \%>\%
    ggplot(mapping = aes(x = price)) +
    geom_hist_()
  ### bar chart
  diamonds \%>\%
    dplyr::sample_n(500) \%>\%
    ggplot(mapping = aes(x = cut)) +
    geom_hist_()
}
}
\seealso{
\code{\link{geom_histogram}}, \code{\link{geom_density_}}
}
