% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-serialaxes-hist.R,
%   R/stat-serialaxes-hist.R
\name{geom_serialaxes_hist}
\alias{geom_serialaxes_hist}
\alias{stat_serialaxes_hist}
\title{Histogram for "widens" data under serial axes coordinate}
\usage{
geom_serialaxes_hist(
  mapping = NULL,
  data = NULL,
  stat = "serialaxes_hist",
  position = "stack_",
  ...,
  axes.sequence = character(0L),
  axes.position = NULL,
  merge = TRUE,
  scale.y = c("data", "group"),
  as.mix = TRUE,
  positive = TRUE,
  prop = 0.9,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_serialaxes_hist(
  mapping = NULL,
  data = NULL,
  geom = "serialaxes_hist",
  position = "stack_",
  ...,
  axes.sequence = character(0L),
  scaling = c("data", "variable", "observation", "none"),
  axes.position = NULL,
  binwidth = NULL,
  bins = NULL,
  center = NULL,
  boundary = NULL,
  breaks = NULL,
  closed = c("right", "left"),
  pad = FALSE,
  width = NULL,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{axes.sequence}{A vector to define the axes sequence. In serial axes coordinate, the sequence can be either
determined in \code{mapping} (function \code{aes()}) or by \code{axes.sequence}. The only difference is that
the \code{mapping} aesthetics will omit the duplicated axes (check examples in \code{\link{geom_serialaxes}}).}

\item{axes.position}{A numerical vector to determine the axes sequence position;
the length should be the same with the length of \code{axes.sequence} (or mapping \code{aesthetics}, see examples).}

\item{merge}{Should \code{axes.sequence} be merged with mapping aesthetics
as a single mapping \code{uneval} object?}

\item{scale.y}{one of \code{data} and \code{group} to specify.
\tabular{ll}{ \strong{Type} \tab \strong{Description}
\cr data (default) \tab The density estimates are scaled by the whole data set
\cr group \tab The density estimates are scaled by each group
}
If the \code{scale.y} is \code{data}, it is meaningful to compare the density (shape and area) across all groups; else
it is only meaningful to compare the density within each group. See details.}

\item{as.mix}{Logical. Within each group, if \code{TRUE}, the sum of the density estimate area is mixed and
scaled to maximum 1. The area of each subgroup (in general, within each group one color represents one subgroup)
is proportional to the count; if \code{FALSE} the area of each subgroup is the same, with maximum 1. See details.}

\item{positive}{If \code{y} is set as the density estimate, where the smoothed curved is faced to,
right (`positive`) or left (`negative`) as vertical layout; up (`positive`) or down (`negative`) as horizontal layout?}

\item{prop}{adjust the proportional maximum height of the estimate (density, histogram, ...).}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{orientation}{The orientation of the layer. The default (\code{NA})
automatically determines the orientation from the aesthetic mapping. In the
rare event that this fails it can be given explicitly by setting \code{orientation}
to either \code{"x"} or \code{"y"}. See the \emph{Orientation} section for more detail.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{geom}{The geometric object to use display the data}

\item{scaling}{one of \code{data}, \code{variable}, \code{observation} or
\code{none} (not suggested the layout is the same with \code{data})
to specify how the data is scaled.}

\item{binwidth}{The width of the bins. Can be specified as a numeric value
or as a function that calculates width from unscaled x. Here, "unscaled x"
refers to the original x values in the data, before application of any
scale transformation. When specifying a function along with a grouping
structure, the function will be called once per group.
The default is to use the number of bins in \code{bins},
covering the range of the data. You should always override
this value, exploring multiple widths to find the best to illustrate the
stories in your data.

The bin width of a date variable is the number of days in each time; the
bin width of a time variable is the number of seconds.}

\item{bins}{Number of bins. Overridden by \code{binwidth}. Defaults to 30.}

\item{center, boundary}{bin position specifiers. Only one, \code{center} or
\code{boundary}, may be specified for a single plot. \code{center} specifies the
center of one of the bins. \code{boundary} specifies the boundary between two
bins. Note that if either is above or below the range of the data, things
will be shifted by the appropriate integer multiple of \code{binwidth}.
For example, to center on integers use \code{binwidth = 1} and \code{center = 0}, even
if \code{0} is outside the range of the data. Alternatively, this same alignment
can be specified with \code{binwidth = 1} and \code{boundary = 0.5}, even if \code{0.5} is
outside the range of the data.}

\item{breaks}{Alternatively, you can supply a numeric vector giving
the bin boundaries. Overrides \code{binwidth}, \code{bins}, \code{center},
and \code{boundary}.}

\item{closed}{One of \code{"right"} or \code{"left"} indicating whether right
or left edges of bins are included in the bin.}

\item{pad}{If \code{TRUE}, adds empty bins at either end of x. This ensures
frequency polygons touch 0. Defaults to \code{FALSE}.}

\item{width}{Bar width. By default, set to 90\% of the resolution of the data.}
}
\description{
Computes and draws histogram on serial axes coordinate for each non-aesthetics component
defined in the mapping \code{aes()}.
}
\examples{
p <- ggplot(NBAstats2021,
            mapping = aes(`FG\%` = `FG\%`,
                          `3P\%` = `3P\%`,
                          `FT\%` = `FT\%`,
                          `OFG\%` = `OFG\%`,
                          `O3P\%` = `O3P\%`,
                          `OFT\%` = `OFT\%`,
                          colour = Playoff,
                          fill = Playoff)) +
            geom_serialaxes(alpha = 0.2,
                            scaling = "variable") +
            geom_serialaxes_hist(alpha = 0.5,
                                 prop = 0.7,
                                 scaling = "variable") +
            scale_x_continuous(breaks = 1:6,
                               labels = c("FG", "3P", "FT",
                                          "OFG", "O3P", "OFT")) +
            scale_y_continuous(labels = NULL) +
            xlab("variable") +
            ylab("") +
            theme(axis.text.x = element_text(angle = 45, vjust = 0.5))
p
}
\seealso{
\code{\link{geom_hist_}}, \code{\link{geom_serialaxes}},
\code{\link{geom_serialaxes_quantile}}, \code{\link{geom_serialaxes_density}}
}
