% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggpage_quick.R
\name{ggpage_quick}
\alias{ggpage_quick}
\title{Creates a quick visualization of the page layout}
\usage{
ggpage_quick(book, lpp = 25, character_height = 3,
  vertical_space = 1, x_space_pages = 10, y_space_pages = 10,
  nrow = NULL, ncol = NULL, bycol = TRUE)
}
\arguments{
\item{book}{Character or data.frame. Can either have each element be a
separate line or having each element being separate words.}

\item{lpp}{Numeric. Lines Per Page. Number of lines allocated for each page.}

\item{character_height}{Numeric. Relative size of the height of each letter
compared to its width.}

\item{vertical_space}{Numeric. Distance between each lines vertically.}

\item{x_space_pages}{Numeric. Distance between pages along the x-axis.}

\item{y_space_pages}{Numeric. Distance between pages along the y-axis.}

\item{nrow}{Numeric. Number of rows of pages, if omitted defaults to square
layout.}

\item{ncol}{Numeric. Number of columns of pages, if omitted defaults to
square layout.}

\item{bycol}{Logical.  If TRUE (the default) the matrix is filled by
columns, otherwise the matrix is filled by rows.}
}
\value{
A ggplot object with the given visualization.
}
\description{
Creates a quick visualization of the page layout
}
\examples{
\donttest{
library(dplyr)
library(stringr)
library(ggplot2)
library(tidytext)
library(ggpage)
# quick
## data.frame with full lines
ggpage_quick(tinderbox)
## vector with full lines
ggpage_quick(tinderbox \%>\%
               pull(text))
## data.frame with single words
ggpage_quick(tinderbox \%>\%
               unnest_tokens(text, text))
## vector with single words
ggpage_quick(tinderbox \%>\%
               unnest_tokens(text, text) \%>\%
               pull(text))

# nrow and ncol
ggpage_quick(tinderbox, nrow = 2)
ggpage_quick(tinderbox, ncol = 2)
}
}
