% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggpie3d.R
\name{ggpie3D}
\alias{ggpie3D}
\title{Create 3D pie plot.}
\usage{
ggpie3D(
  data,
  group_key = NULL,
  count_type = c("count", "full"),
  fill_color = NULL,
  start_degrees = 0,
  tilt_degrees = -20,
  height = 0.1,
  darken = 0.15,
  camera_eye = c(0, 3, 5),
  camera_look_at = c(0, 0, 0),
  show_label = TRUE,
  label_info = c("count", "ratio", "all"),
  label_split = "[[:space:]]+",
  label_size = 4
)
}
\arguments{
\item{data}{Data frame contains full data or summarized data.}

\item{group_key}{Column used to summarize the data. Default: NULL.}

\item{count_type}{Data frame type, chosen from "count" and "full". "count" means summarized data and "full" means full data. Default: count.}

\item{fill_color}{Colors used. Default: NULL (conduct automatic selection).}

\item{start_degrees}{starting angle for first pie slice (in degrees). Default: 0.}

\item{tilt_degrees}{angle by which to tilt the pie towards the camera (in degrees). Default: 0.}

\item{height}{height of the pie. Default: 0.1.}

\item{darken}{Shadow degree. Default: 0.15.}

\item{camera_eye}{location of camera eye. Default: c(0, 3, 5).}

\item{camera_look_at}{at what point is the camera looking. Default: c(0, 0, 0).}

\item{show_label}{Logical value, whether to show label or not. Default: TRUE.}

\item{label_info}{Label information type, chosen from count, ratio and all (count and ratio). Default: count.}

\item{label_split}{Pattern used to split the label, support regular expression. Default: space.}

\item{label_size}{Size of the label. Default: 4.}
}
\value{
A ggplot2 object.
}
\description{
Create 3D pie plot.
}
\examples{
library(ggpie)
library(ggplot2)
data(diamonds)
ggpie3D(data = diamonds, group_key = "cut", count_type = "full", tilt_degrees = -10)
ggpie3D(
  data = mtcars, group_key = "cyl", count_type = "full",
  tilt_degrees = -10, start_degrees = 0
)
data <- data.frame(group = letters[1:5], count = c(1, 2, 3, 1, 1), stringsAsFactors = FALSE)
ggpie3D(data = data, start_degrees = 0, label_split = NULL)
}
