% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-.r
\name{discrete_scale}
\alias{discrete_scale}
\title{Discrete scale constructor.}
\usage{
discrete_scale(aesthetics, scale_name, palette, name = waiver(),
  breaks = waiver(), labels = waiver(), limits = NULL,
  expand = waiver(), na.translate = TRUE, na.value = NA, drop = TRUE,
  guide = "legend", position = "left", super = ScaleDiscrete)
}
\arguments{
\item{aesthetics}{the names of the aesthetics that this scale works with}

\item{scale_name}{the name of the scale}

\item{palette}{a palette function that when called with a single integer
argument (the number of levels in the scale) returns the values that
they should take}

\item{name}{the name of the scale - used as the axis label or the legend
title}

\item{breaks}{control the breaks in the guide.  There are four possible
types of input:
\itemize{
  \item \code{NULL}: don't display any breaks
  \item a character vector giving the breaks as they should appear on the
   axis or in the legend.
  \item \code{waiver()} to use the default break computation.
  \item a function, that when called with a single argument, a character
    vector giving the limits of the scale, returns a character vector
    specifying which breaks to display.
}
This parameter does not affect in any way how the data is scaled - it
only affects the appearance of the legend.}

\item{labels}{\code{NULL} for no labels, \code{waiver()} for default
labels (labels the same as breaks), a character vector the same length
as breaks, or a named character vector whose names are used to match
replacement the labels for matching breaks.}

\item{limits}{A character vector specifying the data range for the scale.
and the default order of their display in guides.}

\item{expand}{a numeric vector of length two, giving a multiplicative and
additive constant used to expand the range of the scales so that there
is a small gap between the data and the axes. The defaults are (0,0.6)
for discrete scales and (0.05,0) for continuous scales.}

\item{na.translate}{Unlike continuous scales, discrete scales can easily show
missing values, and do so by default. If you want to remove missing values
from a discrete scale, specify \code{na.translate = FALSE}.}

\item{na.value}{If \code{na.translate = TRUE}, what value aesthetic
value should missing be displayed as? Does not apply to position scales
where \code{NA} is always placed at the far right.}

\item{drop}{Should unused factor levels be omitted from the scale?
The default, \code{TRUE}, uses the levels that appear in the data;
\code{FALSE} uses all the levels in the factor.}

\item{guide}{the name of, or actual function, used to create the
guide. See \code{\link{guides}} for more info.}

\item{position}{The position of the axis. "left" or "right" for vertical
scales, "top" or "bottom" for horizontal scales}

\item{super}{The super class to use for the constructed scale}
}
\description{
Discrete scale constructor.
}
\keyword{internal}

