% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-density2d.r, R/stat-density-2d.r
\name{geom_density_2d}
\alias{geom_density_2d}
\alias{geom_density2d}
\alias{geom_density_2d_filled}
\alias{geom_density2d_filled}
\alias{stat_density_2d}
\alias{stat_density2d}
\alias{stat_density_2d_filled}
\alias{stat_density2d_filled}
\title{Contours of a 2D density estimate}
\usage{
geom_density_2d(
  mapping = NULL,
  data = NULL,
  stat = "density_2d",
  position = "identity",
  ...,
  contour_var = "density",
  lineend = "butt",
  linejoin = "round",
  linemitre = 10,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_density_2d_filled(
  mapping = NULL,
  data = NULL,
  stat = "density_2d_filled",
  position = "identity",
  ...,
  contour_var = "density",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_density_2d(
  mapping = NULL,
  data = NULL,
  geom = "density_2d",
  position = "identity",
  ...,
  contour = TRUE,
  contour_var = "density",
  n = 100,
  h = NULL,
  adjust = c(1, 1),
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_density_2d_filled(
  mapping = NULL,
  data = NULL,
  geom = "density_2d_filled",
  position = "identity",
  ...,
  contour = TRUE,
  contour_var = "density",
  n = 100,
  h = NULL,
  adjust = c(1, 1),
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{...}{
  Arguments passed on to \code{\link[=geom_contour]{geom_contour}}
  \describe{
    \item{\code{binwidth}}{The width of the contour bins. Overridden by \code{bins}.}
    \item{\code{bins}}{Number of contour bins. Overridden by \code{breaks}.}
    \item{\code{breaks}}{One of:
\itemize{
\item Numeric vector to set the contour breaks
\item A function that takes the range of the data and binwidth as input
and returns breaks as output. A function can be created from a formula
(e.g. ~ fullseq(.x, .y)).
}

Overrides \code{binwidth} and \code{bins}. By default, this is a vector of length
ten with \code{\link[=pretty]{pretty()}} breaks.}
  }}

\item{contour_var}{Character string identifying the variable to contour
by. Can be one of \code{"density"}, \code{"ndensity"}, or \code{"count"}. See the section
on computed variables for details.}

\item{lineend}{Line end style (round, butt, square).}

\item{linejoin}{Line join style (round, mitre, bevel).}

\item{linemitre}{Line mitre limit (number greater than 1).}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}

\item{geom, stat}{Use to override the default connection between
\code{geom_density_2d()} and \code{stat_density_2d()}.}

\item{contour}{If \code{TRUE}, contour the results of the 2d density
estimation.}

\item{n}{Number of grid points in each direction.}

\item{h}{Bandwidth (vector of length two). If \code{NULL}, estimated
using \code{\link[MASS:bandwidth.nrd]{MASS::bandwidth.nrd()}}.}

\item{adjust}{A multiplicative bandwidth adjustment to be used if 'h' is
'NULL'. This makes it possible to adjust the bandwidth while still
using the a bandwidth estimator. For example, \code{adjust = 1/2} means
use half of the default bandwidth.}
}
\description{
Perform a 2D kernel density estimation using \code{\link[MASS:kde2d]{MASS::kde2d()}} and
display the results with contours. This can be useful for dealing with
overplotting. This is a 2D version of \code{\link[=geom_density]{geom_density()}}. \code{geom_density_2d()}
draws contour lines, and \code{geom_density_2d_filled()} draws filled contour
bands.
}
\section{Aesthetics}{

\code{geom_density_2d()} understands the following aesthetics (required aesthetics are in bold):
\itemize{
\item \strong{\code{x}}
\item \strong{\code{y}}
\item \code{alpha}
\item \code{colour}
\item \code{group}
\item \code{linetype}
\item \code{linewidth}
}
Learn more about setting these aesthetics in \code{vignette("ggplot2-specs")}.


\code{geom_density_2d_filled()} understands the following aesthetics (required aesthetics are in bold):
\itemize{
\item \strong{\code{x}}
\item \strong{\code{y}}
\item \code{alpha}
\item \code{colour}
\item \code{fill}
\item \code{group}
\item \code{linetype}
\item \code{linewidth}
\item \code{subgroup}
}
Learn more about setting these aesthetics in \code{vignette("ggplot2-specs")}.
}

\section{Computed variables}{

\code{stat_density_2d()} and \code{stat_density_2d_filled()} compute different
variables depending on whether contouring is turned on or off. With
contouring off (\code{contour = FALSE}), both stats behave the same, and the
following variables are provided:
\describe{
\item{\code{density}}{The density estimate.}
\item{\code{ndensity}}{Density estimate, scaled to a maximum of 1.}
\item{\code{count}}{Density estimate * number of observations in group.}
\item{\code{n}}{Number of observations in each group.}
}

With contouring on (\code{contour = TRUE}), either \code{\link[=stat_contour]{stat_contour()}} or
\code{\link[=stat_contour_filled]{stat_contour_filled()}} (for contour lines or contour bands,
respectively) is run after the density estimate has been obtained,
and the computed variables are determined by these stats.
Contours are calculated for one of the three types of density estimates
obtained before contouring, \code{density}, \code{ndensity}, and \code{count}. Which
of those should be used is determined by the \code{contour_var} parameter.
}

\section{Dropped variables}{

\describe{
\item{\code{z}}{After density estimation, the z values of individual data points are no longer available.}
}

If contouring is enabled, then similarly \code{density}, \code{ndensity}, and \code{count}
are no longer available after the contouring pass.
}

\examples{
m <- ggplot(faithful, aes(x = eruptions, y = waiting)) +
 geom_point() +
 xlim(0.5, 6) +
 ylim(40, 110)

# contour lines
m + geom_density_2d()

\donttest{
# contour bands
m + geom_density_2d_filled(alpha = 0.5)

# contour bands and contour lines
m + geom_density_2d_filled(alpha = 0.5) +
  geom_density_2d(linewidth = 0.25, colour = "black")

set.seed(4393)
dsmall <- diamonds[sample(nrow(diamonds), 1000), ]
d <- ggplot(dsmall, aes(x, y))
# If you map an aesthetic to a categorical variable, you will get a
# set of contours for each value of that variable
d + geom_density_2d(aes(colour = cut))

# If you draw filled contours across multiple facets, the same bins are
# used across all facets
d + geom_density_2d_filled() + facet_wrap(vars(cut))
# If you want to make sure the peak intensity is the same in each facet,
# use `contour_var = "ndensity"`.
d + geom_density_2d_filled(contour_var = "ndensity") + facet_wrap(vars(cut))
# If you want to scale intensity by the number of observations in each group,
# use `contour_var = "count"`.
d + geom_density_2d_filled(contour_var = "count") + facet_wrap(vars(cut))

# If we turn contouring off, we can use other geoms, such as tiles:
d + stat_density_2d(
  geom = "raster",
  aes(fill = after_stat(density)),
  contour = FALSE
) + scale_fill_viridis_c()
# Or points:
d + stat_density_2d(geom = "point", aes(size = after_stat(density)), n = 20, contour = FALSE)
}
}
\seealso{
\code{\link[=geom_contour]{geom_contour()}}, \code{\link[=geom_contour_filled]{geom_contour_filled()}} for information about
how contours are drawn; \code{\link[=geom_bin2d]{geom_bin2d()}} for another way of dealing with
overplotting.
}
