% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-defaults.R
\name{get_geom_defaults}
\alias{get_geom_defaults}
\title{Resolve and get geom defaults}
\usage{
get_geom_defaults(geom, theme = theme_get())
}
\arguments{
\item{geom}{Some definition of a geom:
\itemize{
\item A \code{function} that creates a layer, e.g. \code{geom_path()}.
\item A layer created by such function
\item A string naming a geom class in snake case without the \code{geom_}-prefix,
e.g. \code{"contour_filled"}.
\item A geom class object.
}}

\item{theme}{A \code{\link{theme}} object. Defaults to the current global theme.}
}
\value{
A list of aesthetics
}
\description{
Resolve and get geom defaults
}
\examples{
# Using a function
get_geom_defaults(geom_raster)

# Using a layer includes static aesthetics as default
get_geom_defaults(geom_tile(fill = "white"))

# Using a class name
get_geom_defaults("density_2d")

# Using a class
get_geom_defaults(GeomPoint)
}
\keyword{internal}
