% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-colour-outcome.r
\name{scale_colour_outcome}
\alias{scale_colour_outcome}
\alias{scale_color_outcome}
\alias{scale_fill_outcome}
\title{Colour and fill scales for ternary outcomes}
\usage{
scale_colour_outcome(
  ...,
  name = "Outcome",
  ns.colour = "grey80",
  up.colour = "red",
  down.colour = "dodgerblue2",
  de.colour = "goldenrod",
  na.colour = "black",
  aesthetics = "colour"
)

scale_color_outcome(
  ...,
  name = "Outcome",
  ns.colour = "grey80",
  up.colour = "red",
  down.colour = "dodgerblue2",
  de.colour = "goldenrod",
  na.colour = "black",
  aesthetics = "colour"
)

scale_fill_outcome(
  ...,
  name = "Outcome",
  ns.colour = "grey80",
  up.colour = "red",
  down.colour = "dodgerblue2",
  de.colour = "goldenrod",
  na.colour = "black",
  aesthetics = "fill"
)
}
\arguments{
\item{...}{other named arguments passed to \code{scale_manual}.}

\item{name}{The name of the scale, used for the axis-label.}

\item{ns.colour, down.colour, up.colour, de.colour}{The colour definitions to use for each
of the three possible outcomes.}

\item{na.colour}{colour definition used for NA.}

\item{aesthetics}{Character string or vector of character strings listing the
name(s) of the aesthetic(s) that this scale works with. This can be useful,
for example, to apply colour settings to the colour and fill aesthetics at
the same time, via aesthetics = c("colour", "fill").}
}
\description{
Manual scales for colour and fill aesthetics with defaults suitable for the
three way outcome from some statistical tests.
}
\details{
These scales only alter the \code{breaks}, \code{values}, and
  \code{na.value} default arguments of
  \code{scale_colour_manual()} and \code{scale_fill_manual()}. Please, see
  documentation for \code{\link[ggplot2]{scale_manual}} for details.
}
\examples{

set.seed(12346)
outcome <- sample(c(-1, 0, +1), 50, replace = TRUE)
my.df <- data.frame(x = rnorm(50),
                    y = rnorm(50),
                    outcome2 = outcome2factor(outcome, n.levels = 2),
                    outcome3 = outcome2factor(outcome))

ggplot(my.df, aes(x, y, colour = outcome3)) +
  geom_point() +
  scale_colour_outcome() +
  theme_bw()

ggplot(my.df, aes(x, y, colour = outcome2)) +
  geom_point() +
  scale_colour_outcome() +
  theme_bw()

ggplot(my.df, aes(x, y, fill = outcome3)) +
  geom_point(shape = 21) +
  scale_fill_outcome() +
  theme_bw()

}
\seealso{
Other Functions for quadrant and volcano plots: 
\code{\link{FC_format}()},
\code{\link{geom_quadrant_lines}()},
\code{\link{outcome2factor}()},
\code{\link{scale_shape_outcome}()},
\code{\link{scale_y_Pvalue}()},
\code{\link{stat_quadrant_counts}()},
\code{\link{xy_outcomes2factor}()}
}
\concept{Functions for quadrant and volcano plots}
