% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-quant-line.r
\name{stat_quant_line}
\alias{stat_quant_line}
\title{Predicted line from quantile regression fit}
\usage{
stat_quant_line(
  mapping = NULL,
  data = NULL,
  geom = "smooth",
  position = "identity",
  ...,
  quantiles = c(0.25, 0.5, 0.75),
  formula = NULL,
  se = length(quantiles) == 1L,
  n = 80,
  method = "rq",
  method.args = list(),
  level = 0.95,
  type = "direct",
  interval = "confidence",
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs to be
set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset, only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{position}{The position adjustment to use for overlapping points on this
layer}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}

\item{quantiles}{numeric vector Values in 0..1 indicating the quantiles.}

\item{formula}{a formula object. Using aesthetic names \code{x} and \code{y}
instead of original variable names.}

\item{se}{logical Passed to \code{quantreg::predict.rq()}.}

\item{n}{Number of points at which to evaluate smoother.}

\item{method}{function or character If character, "rq" and
"rqss" are accepted. If a function, it must have formal parameters
\code{formula} and \code{data} and return a model fit object for which
\code{summary()} and \code{coefficients()} are consistent with those for
\code{lm} fits.}

\item{method.args}{named list with additional arguments passed to \code{rq()}
or \code{rqss()}..}

\item{level}{numeric in range [0..1] Passed to \code{quantreg::predict.rq()}.}

\item{type}{character Passed to \code{quantreg::predict.rq()}.}

\item{interval}{character Passed to \code{quantreg::predict.rq()}.}

\item{na.rm}{a logical indicating whether NA values should be stripped before
the computation proceeds.}

\item{orientation}{character Either "x" or "y" controlling the default for
\code{formula}.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}
}
\value{
The value returned by the statistic is a data frame, that will have
  \code{n} rows of predicted values and and their confidence limits for each
  quantile, with each quantile in a group. The variables are \code{x} and
  \code{y} with \code{y} containing predicted values. In addition,
  \code{quantile} and \code{quantile.f} indicate the quantile used and
  and edited \code{group} preserves the original grouping adding a new
  "level" for each quantile. Is \code{se = TRUE}, a confidence band is
  computed and values for it returned in \code{ymax} and \code{ymin}.
}
\description{
Predicted values are computed and, by default, plotted. Depending on the
fit method, a confidence band can be computed and plotted. The confidence
band can be interpreted similarly as that produced by \code{stat_smooth()}
and \code{stat_poly_line()}.
}
\details{
\code{stat_quant_line()} behaves similarly to \code{ggplot2::stat_smooth()}
and \code{stat_poly_line()} but supports fitting regressions for multiple
quantiles in the same plot layer. This statistic interprets the argument
passed to \code{formula} accepting \code{y} as well as \code{x} as
explanatory variable, matching \code{stat_quant_eq()}. While
\code{stat_quant_eq()} supports only method \code{"rq"},
\code{stat_quant_line()} and \code{stat_quant_band()} support both
\code{"rq"} and \code{"rqss"}, In the case of \code{"rqss"} the model
formula makes normally use of \code{qss()} to formulate the spline and its
constraints.

\code{\link[ggplot2]{geom_smooth}}, which is used by default, treats each
axis different and thus is dependent on orientation. If no argument is passed
to \code{formula}, it defaults to \code{y ~ x}. Formulas with \code{y} as
explanatory variable are treated as if \code{x} was the explanatory variable
and \code{orientation = "y"}.

Package 'ggpmisc' does not define a new geometry matching this statistic
as it is enough for the statistic to return suitable \code{x}, \code{y},
\code{ymin}, \code{ymax} and \code{group} values.

There are multiple uses for double regression on x and y. For example, when
two variables are subject to mutual constrains, it is useful to consider both
of them as explanatory and interpret the relationship based on them. So, from
version 0.4.1 'ggpmisc' makes it possible to easily implement the approach
described by Cardoso (2019) under the name of "Double quantile regression".
}
\section{Aesthetics}{
 \code{stat_quant_line} understands \code{x} and \code{y},
  to be referenced in the \code{formula} and \code{weight} passed as argument
  to parameter \code{weights}. All three must be mapped to \code{numeric}
  variables. In addition, the aesthetics understood by the geom
  (\code{"geom_smooth"} is the default) are understood and grouping
  respected.
}

\examples{
ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  stat_quant_line()

ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  stat_quant_line(se = TRUE)

# If you need the fitting to be done along the y-axis set the orientation
ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  stat_quant_line(orientation = "y")

ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  stat_quant_line(orientation = "y", se = TRUE)

ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  stat_quant_line(formula = y ~ x)

ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  stat_quant_line(formula = x ~ y)

ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  stat_quant_line(formula = y ~ poly(x, 3))

ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  stat_quant_line(formula = x ~ poly(y, 3))

# Instead of rq() we can use rqss() to fit an additive model:
library(quantreg)
ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  stat_quant_line(method = "rqss",
                  formula = y ~ qss(x, constraint = "D"),
                  quantiles = 0.5)

ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  stat_quant_line(method = "rqss",
                  formula = x ~ qss(y, constraint = "D"),
                  quantiles = 0.5)

ggplot(mpg, aes(displ, hwy)) +
  geom_point()+
  stat_quant_line(method="rqss",
                  interval="confidence",
                  se = TRUE,
                  mapping = aes(fill = factor(after_stat(quantile)),
                                color = factor(after_stat(quantile))),
                  quantiles=c(0.05,0.5,0.95))

# Smooths are automatically fit to each group (defined by categorical
# aesthetics or the group aesthetic) and for each facet.

ggplot(mpg, aes(displ, hwy, colour = drv, fill = drv)) +
  geom_point() +
  stat_quant_line(method = "rqss",
                  formula = y ~ qss(x, constraint = "V"),
                   quantiles = 0.5)

ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  stat_quant_line(formula = y ~ poly(x, 2)) +
  facet_wrap(~drv)

}
\references{
Cardoso, G. C. (2019) Double quantile regression accurately assesses
  distance to boundary trade-off. Methods in ecology and evolution,
  10(8), 1322-1331.
}
\seealso{
\code{\link[quantreg]{rq}}, \code{\link[quantreg]{rqss}} and
  \code{\link[quantreg]{qss}}.

Other ggplot statistics for quantile regression: 
\code{\link{stat_quant_band}()},
\code{\link{stat_quant_eq}()}
}
\concept{ggplot statistics for quantile regression}
