% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-peaks.R
\name{stat_peaks}
\alias{stat_peaks}
\alias{stat_valleys}
\title{Local maxima (peaks) or minima (valleys)}
\usage{
stat_peaks(
  mapping = NULL,
  data = NULL,
  geom = "point",
  span = 5,
  ignore_threshold = 0,
  strict = FALSE,
  label.fmt = NULL,
  x.label.fmt = NULL,
  y.label.fmt = NULL,
  orientation = "x",
  position = "identity",
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE,
  ...
)

stat_valleys(
  mapping = NULL,
  data = NULL,
  geom = "point",
  span = 5,
  ignore_threshold = 0,
  strict = FALSE,
  label.fmt = NULL,
  x.label.fmt = NULL,
  y.label.fmt = NULL,
  orientation = "x",
  position = "identity",
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}}. Only needs to be
set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data.}

\item{span}{a peak is defined as an element in a sequence which is greater
than all other elements within a window of width span centered at that
element. The default value is 5, meaning that a peak is bigger than two
consecutive neighbors on each side. A \code{NULL} value for \code{span}
is taken as a span covering the whole of the data range.}

\item{ignore_threshold}{numeric value between 0.0 and 1.0 indicating the size
threshold below which peaks will be ignored.}

\item{strict}{logical flag: if TRUE, an element must be strictly greater than
all other values in its window to be considered a peak. Default: FALSE.}

\item{label.fmt}{character  string giving a format definition for converting
values into character strings by means of function \code{\link{sprintf}}
or \code{\link{strptime}}, its use is deprecated.}

\item{x.label.fmt}{character  string giving a format definition for
converting $x$-values into character strings by means of function
\code{\link{sprintf}} or \code{\link{strftime}}. The default argument
varies depending on the scale in use.}

\item{y.label.fmt}{character  string giving a format definition for
converting $y$-values into character strings by means of function
\code{\link{sprintf}}.}

\item{orientation}{character Either "x" or "y".}

\item{position}{The position adjustment to use for overlapping points
on this layer.}

\item{na.rm}{a logical value indicating whether NA values should be
stripped before the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}
}
\description{
\code{stat_peaks} finds at which x positions local y maxima are located and
\code{stat_valleys} finds at which x positions local y minima are located.
Both stats return a subset of \code{data} with rows matching for peaks or
valleys with formatted character labels added. The formatting is determined
by a format string compatible with \code{sprintf()} or \code{strftime()}.
}
\details{
These stats use \code{geom_point} by default as it is the geom most
  likely to work well in almost any situation without need of tweaking. The
  default aesthetics set by these stats allow their direct use with
  \code{geom_text}, \code{geom_label}, \code{geom_line}, \code{geom_rug},
  \code{geom_hline} and \code{geom_vline}. The formatting of the labels
  returned can be controlled by the user.

  The default for parameter \code{strict} is \code{TRUE} in functions
  \code{splus2R::peaks()} and \code{find_peaks()}, while the default is \code{FALSE}
  in \code{stat_peaks()} and in \code{stat_valleys()}.
}
\note{
These statistics check the scale of the \code{x} aesthetic and if it is
  Date or Datetime they correctly generate the labels by transforming the
  numeric \code{x} values to Date or POSIXct objects, respectively. In which
  case the \code{x.label.fmt} must follow the syntax supported by
  \code{strftime()} rather than by \code{sprintf()}. Overlap of labels with
  points can avoided by use of one of the nudge positions, possibly together
  with geometry \code{\link[ggpp]{geom_text_s}} from package
  \code{\link[ggpp]{ggpp}}, or with \code{\link[ggrepel]{geom_text_repel}} or
  \code{\link[ggrepel]{geom_label_repel}} from package
  \code{\link[ggrepel]{ggrepel}}. To discard overlapping labels use
  \code{check_overlap = TRUE} as argument to \code{geom_text} or
  \code{geom_text_s}. By default the labels are character values suitable to
  be plotted as is, but with a suitable format passed as argument to
  \code{label.fmt} labels suitable for parsing by the geoms (e.g. into
  expressions containing Greek letters, super- or subscripts, maths symbols
  or maths constructs) can be also easily obtained.
}
\section{Returned and computed variables}{

\describe{
  \item{x}{x-value at the peak (or valley) as numeric}
  \item{y}{y-value at the peak (or valley) as numeric}
  \item{x.label}{x-value at the peak (or valley) as character}
  \item{y.label}{y-value at the peak (or valley) as character}
}
}

\section{Warning!}{
 The current version of these statistics do not support
  passing \code{nudge_x} or \code{nurge_y} named parameters to the geometry.
  Use `position` and one of the position functions such as
  \code{\link{position_nudge_keep}} instead.
}

\examples{
# lynx is a time.series object
lynx_num.df <-
  try_tibble(lynx,
             col.names = c("year", "lynx"),
             as.numeric = TRUE) # years -> as numeric

ggplot(lynx_num.df, aes(year, lynx)) +
  geom_line() +
  stat_peaks(colour = "red") +
  stat_valleys(colour = "blue")

ggplot(lynx_num.df, aes(lynx, year)) +
  geom_line(orientation = "y") +
  stat_peaks(colour = "red", orientation = "y") +
  stat_valleys(colour = "blue", orientation = "y")

ggplot(lynx_num.df, aes(year, lynx)) +
  geom_line() +
  stat_peaks(colour = "red") +
  stat_peaks(colour = "red", geom = "rug")

ggplot(lynx_num.df, aes(year, lynx)) +
  geom_line() +
  stat_peaks(colour = "red") +
  stat_peaks(colour = "red", geom = "text", hjust = -0.1, angle = 33)

ggplot(lynx_num.df, aes(lynx, year)) +
  geom_line(orientation = "y") +
  stat_peaks(colour = "red", orientation = "y") +
  stat_peaks(colour = "red", orientation = "y",
             geom = "text", hjust = -0.1)

lynx_datetime.df <-
   try_tibble(lynx,
              col.names = c("year", "lynx")) # years -> POSIXct

ggplot(lynx_datetime.df, aes(year, lynx)) +
  geom_line() +
  stat_peaks(colour = "red") +
  stat_valleys(colour = "blue")

ggplot(lynx_datetime.df, aes(year, lynx)) +
  geom_line() +
  stat_peaks(colour = "red") +
  stat_peaks(colour = "red",
             geom = "text",
             hjust = -0.1,
             x.label.fmt = "\%Y",
             angle = 33)

ggplot(lynx_datetime.df, aes(year, lynx)) +
  geom_line() +
  stat_peaks(colour = "red") +
  stat_peaks(colour = "red",
             geom = "text_s",
             position = position_nudge_keep(x = 0, y = 200),
             hjust = -0.1,
             x.label.fmt = "\%Y",
             angle = 90) +
  expand_limits(y = 8000)

ggplot(lynx_datetime.df, aes(year, lynx)) +
  geom_line() +
  stat_peaks(colour = "red",
             geom = "text_s",
             position = position_nudge_to(y = 7600),
             arrow = arrow(length = grid::unit(1.5, "mm")),
             point.padding = 0.7,
             x.label.fmt = "\%Y",
             angle = 90) +
  expand_limits(y = 9000)

}
