% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggstripchart.R
\name{ggstripchart}
\alias{ggstripchart}
\title{Stripcharts}
\usage{
ggstripchart(data, x, y, combine = FALSE, merge = FALSE,
  color = "black", fill = "white", palette = NULL, title = NULL,
  xlab = NULL, ylab = NULL, facet.by = NULL, panel.labs = NULL,
  short.panel.labs = TRUE, shape = 19, size = NULL, select = NULL,
  remove = NULL, order = NULL, add = "mean_se",
  add.params = list(), error.plot = "pointrange", label = NULL,
  font.label = list(size = 11, color = "black"), label.select = NULL,
  repel = FALSE, label.rectangle = FALSE, jitter = 0.2,
  position = position_jitter(jitter), ggtheme = theme_pubr(), ...)
}
\arguments{
\item{data}{a data frame}

\item{x}{character string containing the name of x variable.}

\item{y}{character vector containing one or more variables to plot}

\item{combine}{logical value. Default is FALSE. Used only when y is a vector
containing multiple variables to plot. If TRUE, create a multi-panel plot by
combining the plot of y variables.}

\item{merge}{logical or character value. Default is FALSE. Used only when y is
a vector containing multiple variables to plot. If TRUE, merge multiple y
variables in the same plotting area. Allowed values include also "asis"
(TRUE) and "flip". If merge = "flip", then y variables are used as x tick
labels and the x variable is used as grouping variable.}

\item{color}{outline color.}

\item{fill}{fill color.}

\item{palette}{the color palette to be used for coloring or filling by groups.
Allowed values include "grey" for grey color palettes; brewer palettes e.g.
"RdBu", "Blues", ...; or custom color palette e.g. c("blue", "red"); and
scientific journal palettes from ggsci R package, e.g.: "npg", "aaas",
"lancet", "jco", "ucscgb", "uchicago", "simpsons" and "rickandmorty".}

\item{title}{plot main title.}

\item{xlab}{character vector specifying x axis labels. Use xlab = FALSE to
hide xlab.}

\item{ylab}{character vector specifying y axis labels. Use ylab = FALSE to
hide ylab.}

\item{facet.by}{character vector, of length 1 or 2, specifying grouping
variables for faceting the plot into multiple panels. Should be in the data.}

\item{panel.labs}{a list of one or two character vectors to modify facet panel
labels. For example, panel.labs = list(sex = c("Male", "Female")) specifies
the labels for the "sex" variable. For two grouping variables, you can use
for example panel.labs = list(sex = c("Male", "Female"), rx = c("Obs",
"Lev", "Lev2") ).}

\item{short.panel.labs}{logical value. Default is TRUE. If TRUE, create short
labels for panels by omitting variable names; in other words panels will be
labelled only by variable grouping levels.}

\item{shape}{point shape}

\item{size}{Numeric value (e.g.: size = 1). change the size of points and
outlines.}

\item{select}{character vector specifying which items to display.}

\item{remove}{character vector specifying which items to remove from the plot.}

\item{order}{character vector specifying the order of items.}

\item{add}{character vector for adding another plot element (e.g.: dot plot or
error bars). Allowed values are one or the combination of: "none",
"dotplot", "jitter", "boxplot", "point", "mean", "mean_se", "mean_sd",
"mean_ci", "mean_range", "median", "median_iqr", "median_mad",
"median_range"; see ?desc_statby for more details.}

\item{add.params}{parameters (color, shape, size, fill, linetype) for the
argument 'add'; e.g.: add.params = list(color = "red").}

\item{error.plot}{plot type used to visualize error. Allowed values are one of
c("pointrange", "linerange", "crossbar", "errorbar", "upper_errorbar",
"lower_errorbar", "upper_pointrange", "lower_pointrange", "upper_linerange",
"lower_linerange"). Default value is "pointrange" or "errorbar". Used only
when add != "none" and add contains one "mean_*" or "med_*" where "*" = sd,
se, ....}

\item{label}{the name of the column containing point labels. Can be also a
character vector with length = nrow(data).}

\item{font.label}{a list which can contain the combination of the following
elements: the size (e.g.: 14), the style (e.g.: "plain", "bold", "italic",
"bold.italic") and the color (e.g.: "red") of labels. For example font.label
= list(size = 14, face = "bold", color ="red"). To specify only the size and
the style, use font.label = list(size = 14, face = "plain").}

\item{label.select}{can be of two formats: \itemize{ \item a character vector
specifying some labels to show. \item a list containing one or the
combination of the following components: \itemize{ \item \code{top.up} and
\code{top.down}: to display the labels  of the top up/down points. For
example, \code{label.select = list(top.up = 10, top.down = 4)}. \item
\code{criteria}: to filter, for example, by x and y variabes values, use
this: \code{label.select = list(criteria = "`y` > 2 & `y` < 5 & `x` \%in\%
c('A', 'B')")}. } }}

\item{repel}{a logical value, whether to use ggrepel to avoid overplotting
text labels or not.}

\item{label.rectangle}{logical value. If TRUE, add rectangle underneath the
text, making it easier to read.}

\item{jitter}{the amount of jitter.}

\item{position}{position adjustment, either as a string, or the result of a
call to a position adjustment function. Used to adjust position for
multiple groups.}

\item{ggtheme}{function, ggplot2 theme name. Default value is theme_pubr().
Allowed values include ggplot2 official themes: theme_gray(), theme_bw(),
theme_minimal(), theme_classic(), theme_void(), ....}

\item{...}{other arguments to be passed to
\code{\link[ggplot2]{geom_jitter}}, \code{\link{ggpar}} and
\code{\link{facet}}.}
}
\description{
Create a stripchart, also known as one dimensional scatter
  plots. These plots are suitable compared to box plots when sample sizes are
  small.
}
\details{
The plot can be easily customized using the function ggpar(). Read
  ?ggpar for changing: \itemize{ \item main title and axis labels: main,
  xlab, ylab \item axis limits: xlim, ylim (e.g.: ylim = c(0, 30)) \item axis
  scales: xscale, yscale (e.g.: yscale = "log2") \item color palettes:
  palette = "Dark2" or palette = c("gray", "blue", "red") \item legend title,
  labels and position: legend = "right" \item plot orientation : orientation
  = c("vertical", "horizontal", "reverse") }
}
\examples{
# Load data
data("ToothGrowth")
df <- ToothGrowth

# Basic plot with summary statistics: mean_se
# +++++++++++++++++++++++++++
# Change point shapes by groups: "dose"
ggstripchart(df, x = "dose", y = "len",
   shape = "dose", size = 3,
   add = "mean_se")

# Use mean_sd
# Change error.plot to "crossbar"
ggstripchart(df, x = "dose", y = "len",
   shape = "dose", size = 3,
   add = "mean_sd", add.params = list(width = 0.5),
   error.plot = "crossbar")



# Add summary statistics
# ++++++++++++++++++++++++++

# Add box plot
ggstripchart(df, x = "dose", y = "len",
 shape = "dose", add = "boxplot")

# Add violin + mean_sd
ggstripchart(df, x = "dose", y = "len",
 shape = "dose", add = c("violin", "mean_sd"))


# Change colors
# +++++++++++++++++++++++++++
# Change colors by groups: dose
# Use custom color palette
 ggstripchart(df, "dose", "len",  shape = "dose",
   color = "dose", palette = c("#00AFBB", "#E7B800", "#FC4E07"),
   add = "mean_sd")



# Plot with multiple groups
# +++++++++++++++++++++
# Change shape and color by a second group : "supp"
ggstripchart(df, "dose", "len", shape = "supp",
  color = "supp", palette = c("#00AFBB", "#E7B800"))

# Adjust point position
ggstripchart(df, "dose", "len", shape = "supp",
  color = "supp", palette = c("#00AFBB", "#E7B800"),
  position = position_dodge(0.8) )

# You can also use position_jitterdodge()
# but fill aesthetic is required
ggstripchart(df, "dose", "len",  shape = "supp",
   color = "supp", palette = c("#00AFBB", "#E7B800"),
   position = position_jitterdodge() )

# Add boxplot
ggstripchart(df, "dose", "len", shape = "supp",
 color = "supp", palette = c("#00AFBB", "#E7B800"),
 add = "boxplot", add.params = list(color = "black") )

}
\seealso{
\code{\link{ggpar}}, \code{\link{ggviolin}}, \code{\link{ggdotplot}}
 and \code{\link{ggboxplot}}.
}
