% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggkm.R
\docType{data}
\name{GeomKmband}
\alias{GeomKmband}
\alias{geom_kmband}
\title{Display Kaplan Meier Curve}
\format{An object of class \code{GeomKmband} (inherits from \code{Geom}, \code{ggproto}, \code{gg}) of length 5.}
\usage{
GeomKmband

geom_kmband(mapping = NULL, data = NULL, stat = "kmband",
  position = "identity", show.legend = NA, inherit.aes = TRUE,
  na.rm = TRUE, ...)
}
\description{
Kaplan Meier Curve
}
\section{Aesthetics}{

\code{geom_km} understands the following aesthetics (required aesthetics
are in bold):
\itemize{
  \item \strong{\code{x}} The survival/censoring times. This is automatically mapped by \link{stat_km}
  \item \strong{\code{y}} The survival probability estimates. This is automatically mapped by \link{stat_km}
  smallest level in sort order is assumed to be 0, with a warning
  \item \code{alpha}
  \item \code{color}
  \item \code{linetype}
  \item \code{size}
}
}

\examples{
library(ggplot2)
sex <- rbinom(250, 1, .5)
df <- data.frame(time = exp(rnorm(250, mean = sex)), status = rbinom(250, 1, .75), sex = sex)
ggplot(df, aes(time = time, status = status, color = factor(sex))) + geom_km() + geom_kmband()
}
\seealso{
The default stat for this geom is \code{\link{stat_kmband}} see
  that documentation for more options to control the underlying statistical transformation.
}
\keyword{internal}
