% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_annotations.R
\name{draw_annotations}
\alias{draw_annotations}
\title{Write text annotations from an annotation CSV file (from ggsem Shiny app) on a ggplot2 object}
\usage{
draw_annotations(p, annotations_data, zoom_level = 1)
}
\arguments{
\item{p}{A ggplot2 object}

\item{annotations_data}{The object that stores the CSV file containing information about text annotations from the ggsem Shiny app.}

\item{zoom_level}{A numeric value to control the zoom level of the plot. Default is 1.}
}
\value{
A ggplot object is returned as the function's output.
}
\description{
This function adds text annotations onto any ggplot2 output (including your own plots not created from the ggsem Shiny app).
}
\examples{
library(ggplot2)

annotations_data <- data.frame(
text = 'Square One', x = 26, y = 300, font = 'serif',
size = 20, color = '#000000', angle = 0, alpha = 1,
fontface = 'bold', math_expression = FALSE,
lavaan = FALSE
)

p <- ggplot(mtcars) + geom_point(aes(mpg, disp))

draw_annotations(p, annotations_data, zoom_level = 1.2)
}
