% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensions.R
\docType{data}
\name{pitch_opta}
\alias{pitch_opta}
\alias{pitch_statsbomb}
\alias{pitch_wyscout}
\alias{pitch_international}
\alias{pitch_tracab}
\title{Pitch dimensions}
\format{
An object of class \code{list} of length 10.

An object of class \code{list} of length 10.

An object of class \code{list} of length 10.

An object of class \code{list} of length 10.

An object of class \code{list} of length 10.
}
\usage{
pitch_opta

pitch_statsbomb

pitch_wyscout

pitch_international

pitch_tracab
}
\description{
The coordinate system used to generate pitch markings in
can be customised by supplying a pitch specification to the \code{dimensions}
argument of \code{annotate_pitch}.

ggsoccer provides pitch specifications for a few popular data providers by default.
However, user-defined specifications can also be used.
}
\details{
A "pitch specification" is simply a list of dimensions that define a
coordinate system. The required dimensions are:

\itemize{
\item{"length"}{The length of the pitch from one goal to the other (x axis)}
\item{"width"}{The width of the pitch from touchline to the other (y axis)}
\item{"penalty_box_length"}{The distance from the goalline to the edge of the penalty area}
\item{"penalty_box_width"}{The width of the penalty area}
\item{"six_yard_box_length"}{The distance from the goalline to the edge of the six-yard box}
\item{"six_yard_box_width"}{The width of the six-yard box}
\item{"penalty_spot_distance"}{The distance from the goalline to the penalty spot}
\item{"goal_width"}{The distance from one goal post to the other}
\item{"origin_x"}{The minimum x coordinate of the pitch}
\item{"origin_y"}{The minimum y coordinate of the pitch}
}

The following pitch dimensions are provided
\itemize{
\item{"pitch_opta"}{For Opta f24 data}
\item{"pitch_statsbomb"}{For Statsbomb data}
\item{"pitch_wyscout"}{For Wyscout data}
\item{"pitch_international"}{As per UEFA Category 4 stadium regulations}
\item{"pitch_tracab"}{"For ChyronHego Tracab, using the 105m x 68m default size"}
}
}
\examples{
library(ggplot2)
library(ggsoccer)

ggplot() +
  annotate_pitch(dimensions = pitch_statsbomb) +
  theme_pitch()

}
\seealso{
\code{make_pitch_tracab}
}
\keyword{datasets}
