% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_pitch.R
\name{annotate_pitch}
\alias{annotate_pitch}
\title{Adds soccer pitch markings as a layer for use in a ggplot plot.}
\usage{
annotate_pitch(
  colour = "dimgray",
  fill = "white",
  limits = TRUE,
  dimensions = pitch_opta,
  goals = goals_box,
  linewidth = 0.5,
  alpha = 1,
  linetype = "solid"
)
}
\arguments{
\item{colour}{Colour of pitch outline.}

\item{fill}{Colour of pitch fill.}

\item{limits}{Whether to adjust the plot limits to display the whole pitch.}

\item{dimensions}{A list containing the pitch dimensions to draw. See \code{help(pitch_opta)}.}

\item{goals}{A function for generating goal markings. Defaults to \code{goals_box}.
See \code{help(goals_box)}. Formulas are turned into functions with \code{rlang::as_function}.}

\item{linewidth}{The linewidth of the pitch markings}

\item{alpha}{The transparency of the pitch markings and fill}

\item{linetype}{The linetype of the pitch markings (e.g. "dotted")}
}
\value{
list of ggplot geoms to be added to a ggplot plot
}
\description{
Adds soccer pitch markings as a layer for use in a ggplot plot.
}
\examples{
library(ggplot2)

shots_data <- data.frame(x = c(90, 85, 82, 78, 83),
                         y = c(43, 40, 52, 56, 44))

ggplot(shots_data, aes(x = x, y = y)) +
  annotate_pitch() +
  geom_point()

}
