% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract-projection.R
\name{xyTransform}
\alias{bboxTransform}
\alias{xyTransform}
\title{Project XY coordinates}
\usage{
xyTransform(x, y, from = 4326, to = 4326, na.rm = FALSE)

bboxTransform(bbox, from = 4326, to = 4326)
}
\arguments{
\item{x}{The x values (or longitude)}

\item{y}{The y values (or latitude)}

\item{from}{The source projection, or an object that can be coerced to one
using \link{as.CRS}}

\item{to}{The destination projection, or an object that can be coerce to one
using \link{as.CRS}}

\item{na.rm}{Currently xyTransform does not work with non-finite values.
Pass na.rm = TRUE to remove them, or else a (more helpful) error will be
thrown if non-finite values exist.}

\item{bbox}{The bounding box to transform. Note that bounding boxes are not truly
transformed bounding boxes, but the bounding box of the transformed lower-left
and upper-right coordinates. This is a perfect approximation in cylindrical
systems but questionable in more complex systems.}
}
\value{
A matrix with 2 columns (x and y)
}
\description{
The sp package provides a powerful interface with easy syntax for projection Spatial* objects,
but raw coordinates are not as straightforward. Use this function to project raw
coordinates, and \link[sp]{spTransform} to project Spatial* objects.
}
\examples{
all_latlons <- expand.grid(x=-180:180, y=-70:70)
xyTransform(all_latlons$x, all_latlons$y, from = 4326, to = 3857)
bboxTransform(bbox(longlake_osm), from = 26920)

}

