% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-raw-spct.r
\name{plot.raw_spct}
\alias{plot.raw_spct}
\title{Plot an instrument counts spectrum, especialization of generic plot function.}
\usage{
\method{plot}{raw_spct}(x, ..., w.band = getOption("photobiology.plot.bands",
  default = list(UVC(), UVB(), UVA(), PAR())), range = NULL,
  unit.out = "counts", pc.out = FALSE, label.qty = "average",
  annotations = getOption("photobiology.plot.annotations", default =
  c("boxes", "labels", "colour.guide", "peaks")), norm = NULL)
}
\arguments{
\item{x}{a raw_spct object}

\item{...}{other arguments passed along, such as \code{label.qty}}

\item{w.band}{a single waveband object or a list of waveband objects}

\item{range}{an R object on which range() returns a vector of length 2,
with min annd max wavelengths (nm)}

\item{unit.out}{character IGNORED}

\item{pc.out}{logical, if TRUE use percents instead of fraction of one}

\item{label.qty}{character IGNORED}

\item{annotations}{a character vector ("summaries" is ignored)}

\item{norm}{numeric normalization wavelength (nm) or character string "max"
for normalization at the wavelength of highest peak.}
}
\value{
a \code{ggplot} object.
}
\description{
This function returns a ggplot object with an annotated plot of a
response_spct object.
}
\note{
Note that scales are expanded so as to make space for the annotations.
The object returned is a ggplot objects, and can be further manipulated.
}
\seealso{
Other plot functions: \code{\link{plot.cps_spct}},
  \code{\link{plot.filter_spct}},
  \code{\link{plot.object_spct}},
  \code{\link{plot.reflector_spct}},
  \code{\link{plot.response_spct}},
  \code{\link{plot.source_spct}},
  \code{\link{plot.waveband}}
}
\keyword{hplot}

