% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-response-spct.R
\name{e_rsp_plot}
\alias{e_rsp_plot}
\title{Plot method for response spectra.}
\usage{
e_rsp_plot(spct, w.band, range, pc.out, label.qty, span, annotations, norm,
  text.size, na.rm, ...)
}
\arguments{
\item{spct}{a response_spct object}

\item{w.band}{list of waveband objects}

\item{range}{an R object on which range() returns a vector of length 2, with
min annd max wavelengths (nm)}

\item{pc.out}{logical, if TRUE use percents instead of fraction of one}

\item{label.qty}{character string giving the type of summary quantity to use
for labels, one of "mean", "total", "contribution", and "relative".}

\item{span}{a peak is defined as an element in a sequence which is greater
than all other elements within a window of width span centered at that
element.}

\item{annotations}{a character vector}

\item{norm}{numeric normalization wavelength (nm) or character string "max"
for normalization at the wavelength of highest peak.}

\item{text.size}{numeric size of text in the plot decorations.}

\item{na.rm}{logical.}

\item{...}{other arguments passed to e_response()}
}
\value{
a \code{ggplot} object.
}
\description{
This function returns a ggplot object with an annotated plot of a
response_spct object.
}
\note{
Note that scales are expanded so as to make space for the annotations.
  The object returned is a ggplot objects, and can be further manipulated.
}
\keyword{internal}
