% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decoration.R
\name{set_annotations_default}
\alias{set_annotations_default}
\alias{set_w.band_default}
\title{Set defaults for autoplot annotations}
\usage{
set_annotations_default(annotations = NULL)

set_w.band_default(w.band = NULL)
}
\arguments{
\item{annotations}{character vector Annotations to add or remove from
defaults used by the \code{autoplot()} methods defined in this package..}

\item{w.band}{a single waveband object or a list of waveband objects.}
}
\value{
Previous value of option "photobiology.plot.annotations", returned
  invisibly.
}
\description{
Set R options used when plotting spectra. Option
  "photobiology.plot.annotations" is used as default argument to formal
  parameter \code{annotations} and option "photobiology.plot.bands" is used
  as default argument to formal parameter \code{w.band} in all the
  \code{autoplot()} methods exported from package 'ggspectra'. These
  convenience functions make it easier to edit these two option which are
  stored as a vector of characters strings and a list of waveband objects,
  respectively.
}
\note{
The syntax used and behaviour are the same as for the
  \code{annotations} parameter of the \code{autoplot()} methods for spectra,
  but instead of affecting a single plot, \code{set_annotations_default()}
  changes the default used for subsequent calls to \code{autoplot()}.
}
\section{Plot Annotations}{
 The recognized annotation names are: \code{"summaries"}, \code{"peaks"},
  \code{"peak.labels"}, \code{"valleys"}, \code{"valley.labels"},
  \code{"wls"}, \code{"wls.labels"}, \code{"colour.guide"},
  \code{"color.guide"}, \code{"boxes"}, \code{"segments"}, \code{"labels"}.
  In addition, \code{"+"} is interpreted as a request to add to the already
  present default annotations, \code{"-"} as request to remove annotations
  and \code{"="} or missing\code{"+"} and \code{"-"} as a request to reset
  annotations to those requested. If used, \code{"+"}, \code{"-"} or
  \code{"="} must be the first member of a character vector, and followed by
  one or more of the names given above. To simultaneously add and remove
  annotations one can pass a \code{list} containing \code{character} vectors
  each assembled as described. The vectors are applied in the order they
  appear in the list. To disable all annotations pass \code{""} or
  \code{c("=", "")} as argument. Adding a variation of an annotation already
  present, replaces the existing one automatically: e.g., adding
  \code{"peak.labels"} replaces\code{"peaks"} if present.
}

\section{Title Annotations}{
 metadata retrieved from object \code{object} is
  paased to \code{ggplot2::ggtitle()} as arguments for \code{title},
  \code{subtitle} and \code{caption}. The specification for the title is
  passed as argument to \code{annotations}, and consists in the keyword
  \code{title} with optional modifiers selecting the kind of metatdata to
  use, separated by colons. Up to three keywords separated by colons are
  accepted, and correspond to title, subtitle and caption. The recognized
  keywords are: \code{"objt"}, \code{"class"}, \code{"what"}, \code{"when"},
  \code{"where"}, \code{"how"}, \code{"inst.name"}, \code{"inst.sn"},
  \code{"comment"} and \code{"none"} are recognized as modifiers to
  \code{"title"}; \code{"none"} is a placeholder. Default is
  \code{"title:objt"} or no title depending on the context.
}

\seealso{
Other autoplot methods: 
\code{\link{autoplot.calibration_spct}()},
\code{\link{autoplot.cps_spct}()},
\code{\link{autoplot.filter_spct}()},
\code{\link{autoplot.object_spct}()},
\code{\link{autoplot.raw_spct}()},
\code{\link{autoplot.reflector_spct}()},
\code{\link{autoplot.response_spct}()},
\code{\link{autoplot.source_spct}()},
\code{\link{autoplot.waveband}()}
}
\concept{autoplot methods}
