% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_ggbetween_anova_subtitles.R
\name{subtitle_anova_parametric_repeated}
\alias{subtitle_anova_parametric_repeated}
\title{Making text subtitle for the within-subject anova designs.}
\usage{
subtitle_anova_parametric_repeated(data, x, y, id.variable,
  effsize.type = "unbiased", conf.level = 0.95, k = 2,
  messages = TRUE, ...)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{id.variable}{The subject identification variable from the dataframe
\code{data}. See example}

\item{effsize.type}{Type of effect size for repeated \emph{ANOVA} test. The
argument can be \code{"biased"} (\code{"partial_eta"} for partial eta-squared)
or \code{"unbiased"} (\code{"omega"} for omega-squared for \strong{anova})).}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\code{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{messages}{Decides whether messages references, notes, and warnings
are to be displayed (Default: \code{TRUE}).}

\item{...}{Additional arguments.}
}
\description{
Making text subtitle for the within-subject anova designs.
}
\examples{
\dontrun{
# setup
set.seed(123)
library(ggstatsplot)
library(jmv)
data("bugs", package = "jmv")

# converting to long format
data_bugs <- bugs \%>\%
  dplyr::filter(., !is.na(LDHF) & !is.na(LDLF) & !is.na(HDLF) & !is.na(HDHF)) \%>\%
  tibble::as_tibble(.) \%>\%
  tidyr::gather(., key, value, LDLF:HDHF)

# creating the subtitle
ggstatsplot:::subtitle_anova_parametric_repeated(
  data = data_bugs,
  x = key,
  y = value,
  id.variable = Subject,
  k = 2
)
}
}
\author{
Chuck Powell, Indrajeet Patil
}
\keyword{internal}
