% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_ggpiestats_subtitles.R
\name{subtitle_onesample_proptest}
\alias{subtitle_onesample_proptest}
\title{Making text subtitle for Proportion Test (N Outcomes)}
\usage{
subtitle_onesample_proptest(data, main, counts = NULL, ratio = NULL,
  conf.level = 0.95, conf.type = "norm", nboot = 100,
  stat.title = NULL, legend.title = NULL, k = 2, messages = TRUE,
  ...)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{main}{The variable to use as the \strong{rows} in the
contingency table.}

\item{counts}{A string naming a variable in data containing counts, or \code{NULL}
if each row represents a single observation (Default).}

\item{ratio}{A vector of numbers: the expected proportions for the proportion
test. Default is \code{NULL}, which means if there are two levels \code{ratio = c(1,1)}, etc.}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\code{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{conf.type}{A vector of character strings representing the type of
intervals required. The value should be any subset of the values \code{"norm"},
\code{"basic"}, \code{"perc"}, \code{"bca"}. For more, see \code{?boot::boot.ci}.}

\item{nboot}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}

\item{stat.title}{Title for the effect being investigated with the chi-square
test. The default is \code{NULL}, i.e. no title will be added to describe the
effect being shown. An example of a \code{stat.title} argument will be something
like \code{"main x condition"} or \code{"interaction"}.}

\item{legend.title}{Title text for the legend.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}

\item{...}{Additional arguments (currently ignored).}
}
\description{
This is going to be a chi-squared Goodness of fit test.
}
\details{
For more details about how the effect sizes and their confidence
intervals were computed, see documentation in \code{?rcompanion::cramerVFit}.
}
\examples{

# for reproducibility
set.seed(123)
library(jmv)

# with counts
subtitle_onesample_proptest(
  data = as.data.frame(HairEyeColor),
  main = Eye,
  counts = Freq,
  ratio = c(0.2, 0.2, 0.3, 0.3)
)

# in case of no variation, only sample size will be shown
subtitle_onesample_proptest(
  data = cbind.data.frame(x = rep("a", 10)),
  main = x
)
}
\author{
Indrajeet Patil
}
