% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_ggbetween_t_subtitles.R
\name{subtitle_t_bayes}
\alias{subtitle_t_bayes}
\title{Making text subtitle for the bayesian t-test.}
\usage{
subtitle_t_bayes(data, x, y, bf.prior = 0.707, paired = FALSE, k = 2,
  ...)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{bf.prior}{A number between 0.5 and 2 (default \code{0.707}), the prior width
to use in calculating Bayes factors.}

\item{paired}{Logical that decides whether the design is repeated
measures/within-subjects (in which case one-way Friedman Rank Sum Test will
be carried out) or between-subjects (in which case one-way Kruskal–Wallis H
test will be carried out). The default is \code{FALSE}.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{...}{Additional arguments.}
}
\description{
Making text subtitle for the bayesian t-test.
}
\examples{
# for reproducibility
set.seed(123)

# between-subjects design

ggstatsplot::subtitle_t_bayes(
  data = mtcars,
  x = am,
  y = wt,
  paired = FALSE
)

# within-subjects design

ggstatsplot::subtitle_t_bayes(
  data = dplyr::filter(
    ggstatsplot::intent_morality,
    condition \%in\% c("accidental", "attempted"),
    harm == "Poisoning"
  ),
  x = condition,
  y = rating,
  paired = TRUE
)
}
\author{
Indrajeet Patil
}
