% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_ggbetweenstats.R
\name{lm_effsize_standardizer}
\alias{lm_effsize_standardizer}
\title{Standardize a dataframe with effect sizes for \code{aov}, \code{lm}, \code{aovlist},
etc. objects.}
\usage{
lm_effsize_standardizer(object, effsize = "eta", partial = TRUE,
  conf.level = 0.95, nboot = 500)
}
\arguments{
\item{object}{The linear model object (can be of class \code{lm}, \code{aov}, \code{anova}, or
\code{aovlist}).}

\item{effsize}{Character describing the effect size to be displayed: \code{"eta"}
(default) or \code{"omega"}.}

\item{partial}{Logical that decides if partial eta-squared or omega-squared
are returned (Default: \code{TRUE}). If \code{FALSE}, eta-squared or omega-squared
will be returned. Valid only for objects of class \code{lm}, \code{aov}, \code{anova}, or
\code{aovlist}.}

\item{conf.level}{Numeric specifying Level of confidence for the confidence
interval (Default: \code{0.95}).}

\item{nboot}{Number of bootstrap samples for confidence intervals for partial
eta-squared and omega-squared (Default: \code{500}).}
}
\description{
Standardize a dataframe with effect sizes for \code{aov}, \code{lm}, \code{aovlist},
etc. objects.
}
\examples{
\dontrun{
ggstatsplot:::lm_effsize_standardizer(
  stats::lm(formula = brainwt ~ vore, data = ggplot2::msleep),
  partial = FALSE,
  conf.level = 0.99,
  nboot = 50
)
}
}
\keyword{internal}
