% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.grouped_list}
\alias{.grouped_list}
\title{Split data frame into a list by grouping variable.}
\usage{
.grouped_list(data, grouping.var = NULL)
}
\arguments{
\item{data}{A data frame (or a tibble) from which variables specified are to
be taken. Other data types (e.g., matrix,table, array, etc.) will \strong{not}
be accepted. Additionally, grouped data frames from \code{{dplyr}} should be
ungrouped before they are entered as \code{data}.}

\item{grouping.var}{A single grouping variable.}
}
\description{
This function splits the data frame into a list, with the length of the list
equal to the factor levels of the grouping variable.
}
\examples{
\donttest{
ggstatsplot:::.grouped_list(ggplot2::msleep, grouping.var = vore)
}
}
\keyword{internal}
