% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcorrmat.R
\name{grouped_ggcorrmat}
\alias{grouped_ggcorrmat}
\title{Visualization of a correlalogram (or correlation matrix) for all
levels of a grouping variable}
\usage{
grouped_ggcorrmat(
  data,
  ...,
  grouping.var,
  plotgrid.args = list(),
  annotation.args = list()
)
}
\arguments{
\item{data}{A data frame from which variables specified are to be taken.}

\item{...}{
  Arguments passed on to \code{\link[=ggcorrmat]{ggcorrmat}}
  \describe{
    \item{\code{cor.vars}}{List of variables for which the correlation matrix is to be
computed and visualized. If \code{NULL} (default), all numeric variables from
\code{data} will be used.}
    \item{\code{cor.vars.names}}{Optional list of names to be used for \code{cor.vars}. The
names should be entered in the same order.}
    \item{\code{partial}}{Can be \code{TRUE} for partial correlations. For Bayesian partial
correlations, "full" instead of pseudo-Bayesian partial correlations (i.e.,
Bayesian correlation based on frequentist partialization) are returned.}
    \item{\code{matrix.type}}{Character, \code{"upper"} (default), \code{"lower"}, or \code{"full"},
display full matrix, lower triangular or upper triangular matrix.}
    \item{\code{sig.level}}{Significance level (Default: \code{0.05}). If the \emph{p}-value in
\emph{p}-value matrix is bigger than \code{sig.level}, then the corresponding
correlation coefficient is regarded as insignificant and flagged as such in
the plot.}
    \item{\code{colors}}{A vector of 3 colors for low, mid, and high correlation values.
If set to \code{NULL}, manual specification of colors will be turned off and 3
colors from the specified \code{palette} from \code{package} will be selected.}
    \item{\code{pch}}{Decides the point shape to be used for insignificant correlation
coefficients (only valid when \code{insig = "pch"}). Default: \code{pch = "cross"}.}
    \item{\code{ggcorrplot.args}}{A list of additional (mostly aesthetic) arguments that
will be passed to \code{ggcorrplot::ggcorrplot()} function. The list should avoid
any of the following arguments since they are already internally being
used: \code{corr}, \code{method}, \code{p.mat}, \code{sig.level}, \code{ggtheme}, \code{colors}, \code{lab},
\code{pch}, \code{legend.title}, \code{digits}.}
    \item{\code{type}}{A character specifying the type of statistical approach:
\itemize{
\item \code{"parametric"}
\item \code{"nonparametric"}
\item \code{"robust"}
\item \code{"bayes"}
}

You can specify just the initial letter.}
    \item{\code{k}}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}
    \item{\code{conf.level}}{Scalar between \code{0} and \code{1} (default: \verb{95\%}
confidence/credible intervals, \code{0.95}). If \code{NULL}, no confidence intervals
will be computed.}
    \item{\code{tr}}{Trim level for the mean when carrying out \code{robust} tests. In case
of an error, try reducing the value of \code{tr}, which is by default set to
\code{0.2}. Lowering the value might help.}
    \item{\code{bf.prior}}{A number between \code{0.5} and \code{2} (default \code{0.707}), the prior
width to use in calculating Bayes factors and posterior estimates. In
addition to numeric arguments, several named values are also recognized:
\code{"medium"}, \code{"wide"}, and \code{"ultrawide"}, corresponding to \emph{r} scale values
of 1/2, sqrt(2)/2, and 1, respectively. In case of an ANOVA, this value
corresponds to scale for fixed effects.}
    \item{\code{p.adjust.method}}{Adjustment method for \emph{p}-values for multiple
comparisons. Possible methods are: \code{"holm"} (default), \code{"hochberg"},
\code{"hommel"}, \code{"bonferroni"}, \code{"BH"}, \code{"BY"}, \code{"fdr"}, \code{"none"}.}
    \item{\code{subtitle}}{The text for the plot subtitle. Will work only if
\code{results.subtitle = FALSE}.}
    \item{\code{caption}}{The text for the plot caption. This argument is relevant only
if \code{bf.message = FALSE}.}
    \item{\code{ggplot.component}}{A \code{ggplot} component to be added to the plot prepared
by \code{{ggstatsplot}}. This argument is primarily helpful for \code{grouped_}
variants of all primary functions. Default is \code{NULL}. The argument should
be entered as a \code{{ggplot2}} function or a list of \code{{ggplot2}} functions.}
    \item{\code{package,palette}}{Name of the package from which the given palette is to
be extracted. The available palettes and packages can be checked by running
\code{View(paletteer::palettes_d_names)}.}
    \item{\code{ggtheme}}{A \code{{ggplot2}} theme. Default value is
\code{ggstatsplot::theme_ggstatsplot()}. Any of the \code{{ggplot2}} themes (e.g.,
\code{theme_bw()}), or themes from extension packages are allowed (e.g.,
\code{ggthemes::theme_fivethirtyeight()}, \code{hrbrthemes::theme_ipsum_ps()}, etc.).
But note that sometimes these themes will remove some of the details that
\code{{ggstatsplot}} plots typically contains. For example, if relevant,
\code{ggbetweenstats()} shows details about multiple comparison test as a label
on the secondary Y-axis. Some themes (e.g.
\code{ggthemes::theme_fivethirtyeight()}) will remove the secondary Y-axis and
thus the details as well.}
  }}

\item{grouping.var}{A single grouping variable.}

\item{plotgrid.args}{A \code{list} of additional arguments passed to
\code{patchwork::wrap_plots()}, except for \code{guides} argument which is already
separately specified here.}

\item{annotation.args}{A \code{list} of additional arguments passed to
\code{patchwork::plot_annotation()}.}
}
\description{
Helper function for \code{ggstatsplot::ggcorrmat()} to apply this function across
multiple levels of a given factor and combining the resulting plots using
\code{ggstatsplot::combine_plots()}.
}
\details{
For details, see:
\url{https://indrajeetpatil.github.io/ggstatsplot/articles/web_only/ggcorrmat.html}
}
\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true") && requireNamespace("ggcorrplot", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# for reproducibility
set.seed(123)
library(ggcorrplot) # for plot

grouped_ggcorrmat(
  data = iris,
  grouping.var = Species,
  type = "robust",
  p.adjust.method = "holm",
  plotgrid.args = list(ncol = 1),
  annotation.args = list(tag_levels = "i")
)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{ggcorrmat}}, \code{\link{ggscatterstats}},
\code{\link{grouped_ggscatterstats}}
}
