% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_ggsurvfit.R
\name{scale_ggsurvfit}
\alias{scale_ggsurvfit}
\title{Apply Scales}
\usage{
scale_ggsurvfit(x_scales = list(), y_scales = list())
}
\arguments{
\item{x_scales}{a named list of arguments that will be passed to \code{ggplot2::scale_x_continuous()}.}

\item{y_scales}{a named list of arguments that will be passed to \code{ggplot2::scale_y_continuous()}.}
}
\value{
a ggplot2 figure
}
\description{
The most common figure created with this package is a survival curve.
This scale applies modifications often seen in these figures.
\itemize{
\item \code{scale_y_continuous(expand = c(0.025, 0), limits = c(0, 1), label = scales::label_percent())}.
\item \code{scale_x_continuous(expand = c(0.015, 0), n.breaks = 8)}
}

If you use this function, you \strong{must} include \strong{all} scale specifications
that would appear in \code{scale_x_continuous()} or \code{scale_y_continuous()}.
For example, it's common you'll need to specify the x-axis break points.
\code{scale_ggsurvfit(x_scales=list(breaks=0:9))}.

To reset any of the above settings to their ggplot2 default, set the value
to \code{NULL}, e.g. \code{y_scales = list(limits = NULL)}.
}
\examples{
ggsurvfit <-
  survfit2(Surv(time, status) ~ surg, data = df_colon) \%>\%
  ggsurvfit(size = 1) +
  add_confidence_interval()

# use the function defaults
ggsurvfit + scale_ggsurvfit()

# specify additional scales
ggsurvfit +
  scale_ggsurvfit(x_scales = list(breaks = seq(0, 8, by = 2)))
}
