% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-build.R
\name{ggplot_build}
\alias{ggplot_build}
\alias{layer_data}
\alias{layer_grob}
\alias{layer_scales}
\title{Build ggplot for rendering.}
\usage{
ggplot_build(plot)

layer_data(plot, i = 1L)

layer_scales(plot, i = 1L, j = 1L)

layer_grob(plot, i = 1L)
}
\arguments{
\item{plot}{ggplot object}
}
\description{
\code{ggplot_build} takes the plot object, and performs all steps necessary
to produce an object that can be rendered.  This function outputs two pieces:
a list of data frames (one for each layer), and a panel object, which
contain all information about axis limits, breaks etc.
}
\details{
\code{layer_data}, \code{layer_grob}, and \code{layer_scales} are helper
functions that returns the data, grob, or scales associated with a given
layer. These are useful for tests.
}
\seealso{
\code{\link{print.ggplot}} and \code{\link{benchplot}} for
 functions that contain the complete set of steps for generating
 a ggplot2 plot.
}
\keyword{internal}

