% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stata.R
\name{scale_linetype_stata}
\alias{scale_linetype_stata}
\title{Stata linetype palette (discrete)}
\usage{
scale_linetype_stata(...)
}
\arguments{
\item{...}{common discrete scale parameters: \code{name}, \code{breaks},
\code{labels}, \code{na.value}, \code{limits} and \code{guide}.  See
\code{\link{discrete_scale}} for more details}
}
\description{
See \code{\link{stata_linetype_pal}} for details.
}
\examples{
require("dplyr")
require("tidyr")
require("ggplot2")

rescale01 <- function(x) {
  (x - min(x)) / diff(range(x))
}

gather(economics, variable, value, -date) \%>\%
  group_by(variable) \%>\%
  mutate(value = rescale01(value)) \%>\%
  ggplot(aes(x = date, y = value, linetype = variable)) +
  geom_line() +
  scale_linetype_stata()
}
\seealso{
Other linetype stata: \code{\link{stata_linetype_pal}}
}
