% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stata.R
\name{theme_stata}
\alias{theme_stata}
\title{Themes based on Stata graph schemes}
\usage{
theme_stata(base_size = 11, base_family = "sans", scheme = "s2color")
}
\arguments{
\item{base_size}{base font size}

\item{base_family}{base font family}

\item{scheme}{One of "s2color", "s2mono", "s1color",
"s1rcolor", or "s1mono", "s2manual",
"s1manual", or "sj"}
}
\description{
Themes based on Stata graph schemes
}
\note{
Stata graph schemes include the features of \pkg{ggplot2}
into themes and scales. Stata graph themes also allow for defaults
for specific graph types, a feature which \pkg{ggplot2} does not directly
support.
}
\examples{
library("ggplot2")

p <- ggplot(mtcars) +
     geom_point(aes(x = wt, y = mpg, colour = factor(gear))) +
    facet_wrap(~am)
# s2color
p + theme_stata() + scale_colour_stata("s2color")
# s2mono
p + theme_stata(scheme = "s2mono") + scale_colour_stata("mono")
# s1color
p + theme_stata(scheme = "s2color") + scale_colour_stata("s1color")
# s1rcolor
p + theme_stata(scheme = "s1rcolor") + scale_colour_stata("s1rcolor")
# s1mono
p + theme_stata(scheme = "s1mono") + scale_colour_stata("mono")
}
\references{
\url{http://www.stata.com/help.cgi?schemes}
}
