% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stata.R
\name{scale_shape_stata}
\alias{scale_shape_stata}
\title{Stata shape scale}
\usage{
scale_shape_stata(...)
}
\arguments{
\item{...}{Arguments passed on to \code{discrete_scale}
\describe{
  \item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the
transformation object
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output
}}
  \item{limits}{A character vector that defines possible values of the scale
and their order.}
  \item{drop}{Should unused factor levels be omitted from the scale?
The default, \code{TRUE}, uses the levels that appear in the data;
\code{FALSE} uses all the levels in the factor.}
  \item{na.translate}{Unlike continuous scales, discrete scales can easily show
missing values, and do so by default. If you want to remove missing values
from a discrete scale, specify \code{na.translate = FALSE}.}
  \item{na.value}{If \code{na.translate = TRUE}, what value aesthetic
value should missing be displayed as? Does not apply to position scales
where \code{NA} is always placed at the far right.}
  \item{aesthetics}{The names of the aesthetics that this scale works with}
  \item{scale_name}{The name of the scale}
  \item{palette}{A palette function that when called with a single integer
argument (the number of levels in the scale) returns the values that
they should take}
  \item{name}{The name of the scale. Used as axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}
  \item{labels}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item A function that takes the breaks as input and returns labels
as output
}}
  \item{guide}{A function used to create a guide or its name. See
\code{\link[=guides]{guides()}} for more info.}
  \item{super}{The super class to use for the constructed scale}
}}
}
\description{
See \code{\link{stata_shape_pal}} for details.
}
\examples{
library("ggplot2")

p <- ggplot(mtcars) +
     geom_point(aes(x = wt, y = mpg, shape = factor(gear))) +
     facet_wrap(~am)
p + theme_stata() + scale_shape_stata()
}
\concept{shape stata}
