% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/inputs.R
\name{input_checkbox}
\alias{input_checkbox}
\title{Create an interactive checkbox.}
\usage{
input_checkbox(value = FALSE, label = "", id = rand_id("checkbox_"),
  map = identity)
}
\arguments{
\item{value}{Initial value (\code{TRUE} or \code{FALSE}).}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{id}{A unique identifier for this input. Usually generated
automatically.}

\item{map}{A function with single argument \code{x}, the value of the
control on the client. Returns a modified value.}
}
\description{
Create an interactive checkbox.
}
\examples{
input_checkbox(label = "Confidence interval")
input_checkbox(label = "Confidence interval", value = TRUE)

# Used in layer_smooths
mtcars \%>\% ggvis(~wt, ~mpg) \%>\%
  layer_smooths(se = input_checkbox(label = "Confidence interval"))

# Used with a map function, to convert the boolean to another type of value
model_type <- input_checkbox(label = "Use flexible curve",
  map = function(val) if(val) "loess" else "lm")
mtcars \%>\% ggvis(~wt, ~mpg) \%>\%
  layer_model_predictions(model = model_type)
}
\seealso{
Other interactive input: \code{\link{input_checkboxgroup}},
  \code{\link{input_radiobuttons}},
  \code{\link{input_select}}; \code{\link{input_numeric}},
  \code{\link{input_text}}; \code{\link{input_slider}}
}

