% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/inputs.R
\name{input_slider}
\alias{input_slider}
\title{Create an interactive slider.}
\usage{
input_slider(min, max, value = (min + max)/2, step = NULL, round = FALSE,
  format = NULL, locale = "us", ticks = TRUE, animate = FALSE,
  sep = ",", pre = NULL, post = NULL, label = "",
  id = rand_id("slider_"), map = identity)
}
\arguments{
\item{min}{The minimum value (inclusive) that can be selected.}

\item{max}{The maximum value (inclusive) that can be selected.}

\item{value}{The initial value of the slider. A numeric vector of length
one will create a regular slider; a numeric vector of length two will
create a double-ended range slider. A warning will be issued if the
value doesn't fit between \code{min} and \code{max}.}

\item{step}{Specifies the interval between each selectable value on the
slider (if \code{NULL}, a heuristic is used to determine the step size).}

\item{round}{\code{TRUE} to round all values to the nearest integer;
\code{FALSE} if no rounding is desired; or an integer to round to that
number of digits (for example, 1 will round to the nearest 10, and -2 will
round to the nearest .01). Any rounding will be applied after snapping to
the nearest step.}

\item{format}{Deprecated.}

\item{locale}{Deprecated.}

\item{ticks}{\code{FALSE} to hide tick marks, \code{TRUE} to show them
according to some simple heuristics.}

\item{animate}{\code{TRUE} to show simple animation controls with default
settings; \code{FALSE} not to; or a custom settings list, such as those
created using \code{\link{animationOptions}}.}

\item{sep}{Separator between thousands places in numbers.}

\item{pre}{A prefix string to put in front of the value.}

\item{post}{A suffix string to put after the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{id}{A unique identifier for this input. Usually generated
automatically.}

\item{map}{A function with single argument \code{x}, the value of the
control on the client. Returns a modified value.}
}
\description{
Create an interactive slider.
}
\examples{
input_slider(0, 100)
input_slider(0, 100, label = "binwidth")
input_slider(0, 100, value = 50)

# Supply two values to value to make a double-ended sliders
input_slider(0, 100, c(25, 75))

# You can use map to transform the outputs
input_slider(-5, 5, label = "Log scale", map = function(x) 10 ^ x)
}
\seealso{
Other interactive input: \code{\link{input_checkboxgroup}},
  \code{\link{input_radiobuttons}},
  \code{\link{input_select}}; \code{\link{input_checkbox}};
  \code{\link{input_numeric}}, \code{\link{input_text}}
}

