% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggwordcloud-wrapper.R
\name{ggwordcloud2}
\alias{ggwordcloud2}
\title{wordcloud2 approximate replacement}
\usage{
ggwordcloud2(data, size = 1, color = "random-dark",
  minRotation = -pi/4, maxRotation = pi/4, shuffle = TRUE,
  rotateRatio = 0.4, shape = "circle", ellipticity = 0.65,
  figPath = NA, ...)
}
\arguments{
\item{data}{a dataframe whose two first columns are the names and the freqs
or a table}

\item{size}{scaling factor. Default to 1}

\item{color}{color scheme either "random-dark", "random-light" or a list of
color of the size of the dataframe. Default to "random-dark"}

\item{minRotation}{the minimal rotation angle}

\item{maxRotation}{the maximal rotation angle}

\item{shuffle}{if TRUE, the words are shuffled at the beginning}

\item{rotateRatio}{the proportion of rotated words}

\item{shape}{control the shape of the cloud}

\item{ellipticity}{control the eccentricity of the wordcloud}

\item{figPath}{path to an image used a mask}

\item{...}{the remaining parameters are passed to geom_text_wordcloud}
}
\value{
a ggplot
}
\description{
\code{ggwordcloud2} is meant as an approximate replacement for
\code{\link[wordcloud2]{wordcloud2}}. It has almost the same syntax but fewer
options. In particular, there is no background image (so far...). As the
underlying algorithms are not strictly equal, the resulting wordcloud is only
similar to the ones one can obtain with \code{\link[wordcloud2]{wordcloud2}}.
}
\examples{
set.seed(42)
data("love_words_small")

ggwordcloud2(love_words_small[,c("word", "speakers")])
}
