% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gh_gql.R
\name{gh_gql}
\alias{gh_gql}
\title{A simple interface for the GitHub GraphQL API v4.}
\usage{
gh_gql(query, ...)
}
\arguments{
\item{query}{The GraphQL query, as a string.}

\item{...}{Name-value pairs giving API parameters. Will be matched into
\code{endpoint} placeholders, sent as query parameters in GET requests, and as a
JSON body of POST requests. If there is only one unnamed parameter, and it
is a raw vector, then it will not be JSON encoded, but sent as raw data, as
is. This can be used for example to add assets to releases. Named \code{NULL}
values are silently dropped. For GET requests, named \code{NA} values trigger an
error. For other methods, named \code{NA} values are included in the body of the
request, as JSON \code{null}.}
}
\description{
See more about the GraphQL API here:
\url{https://docs.github.com/graphql}
}
\details{
Note: pagination and the \code{.limit} argument does not work currently,
as pagination in the GraphQL API is different from the v3 API.
If you need pagination with GraphQL, you'll need to do that manually.
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
gh_gql("query { viewer { login }}")

# Get rate limit
ratelimit_query <- "query {
  viewer {
    login
  }
  rateLimit {
    limit
    cost
    remaining
    resetAt
  }
}"

gh_gql(ratelimit_query)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=gh]{gh()}} for the GitHub v3 API.
}
