% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mute_tokens.R
\name{mute_tokens}
\alias{mute_tokens}
\title{Mute tokens by condition}
\usage{
mute_tokens(tbl, condition, .as = NA_character_)
}
\arguments{
\item{tbl}{A tidy text dataset.}

\item{condition}{<\code{\link[rlang:args_data_masking]{data-masked}}>
A logical expression.}

\item{.as}{String with which tokens are replaced
when they are matched to condition.
The default value is \code{NA_character}.}
}
\value{
A data.frame.
}
\description{
Replaces tokens in the tidy text dataset with a string scalar
only if they are matched to an expression.
}
\examples{
\dontrun{
df <- tokenize(
  data.frame(
    doc_id = seq_along(ginga[5:8]),
    text = ginga[5:8]
  )
) |>
  prettify(col_select = "POS1")

head(mute_tokens(df, POS1 \%in\% c("\u52a9\u8a5e", "\u52a9\u52d5\u8a5e")))
}
}
