% Generated by roxygen2 (4.0.2): do not edit by hand
\name{gimme}
\alias{gimme}
\title{Group iterative multiple model estimation.}
\usage{
gimme(data     = "",
      sep      = "",
      header   = ,
      out      = "",
      ar       = FALSE,
      plot     = TRUE,
      subgroup = FALSE,
      paths    = NULL)
}
\arguments{
\item{data}{Path to the directory where the data files are located. Each file must contain one matrix for each
individual containing a T (time) by p (number of variables) matrix where the columns represent variables and
the rows represent time.}

\item{sep}{The spacing of the data files. "" indicates space-delimited, "/t" indicates tab-delimited, ","
indicates comma delimited.}

\item{header}{Logical. Indicate TRUE for data files with a header.}

\item{out}{The path to the directory where the results will be stored. This must be generated by the user prior
to running the function.}

\item{ar}{Logical. If TRUE, begins search for group model with autoregressive (AR) paths open. Defaults to FALSE.}

\item{plot}{Logical. If TRUE, graphs depicting relations among variables of interest will automatically be
created. For individual-level plots, red paths represent positive weights and blue paths represent negative weights. For the group-level plot, black represents group-level paths, grey represents individual-level paths, and (if subgroup = TRUE) green represents subgroup-level paths. For the group-level plot, the width of the edge corresponds to the count. Defaults to TRUE.}

\item{subgroup}{Logical.Logical. If TRUE, subgroups are generated based on similarities in model features using the \code{walktrap.community} function from the \code{igraph} package.}

\item{paths}{\code{lavaan}-style syntax containing paths with which to begin model estimation. That is, Y~X indicates that Y is regressed on X, or X predicts Y. If no header is used,
then variables should be referred to with V followed (with no separation) by the column number. If a
header is used, variables should be referred to using variable names. To reference lag variables, "lag"
should be added to the end of the variable name with no separation. Defaults to TRUE.}
}
\description{
This function identifies structural equation models for each individual that consist of both group-level and individual-level paths.
}
\details{
In main output directory:
 \itemize{
 \item{all.elements.summary} {Contains summary information for paths identified at the group- and individual-level.}
 \item{all.elements} {Contains information for all paths identified at the group- and individual-level.}
 \item{all.fit} {Contains model fit information for individual-level models. If subgroups are requested, this file also contains the subgroup membership for each individual.}
 \item{finalpaths_contemp} Contains counts of total number of paths (contemporaneous predicting contemporaneous) estimated for sample.
 \item{finalpaths_lagged} Contains counts of total number of paths (lagged predicting contemporaneous) estimated for the sample.
 }
 In subgroup output directory (if subgroup = TRUE):
 \itemize{
 \item{subgroupk_contemp} Contains counts of relations among contemporaneous variables for the kth subgroup.
 \item{subgroupk_lagged} Contains counts of relations among lagged and contemporaneous variables for the kth subgroup.
 \item{subgroupk_plot} Contains plot of group, subgroup, and individual level paths for the kth subgroup. Black represents group-level paths, grey represents individual-level paths, and green represents subgroup-level paths.
 }
 In individual output directory:
 \itemize{
 \item{betas} Directory, contains individual-level estimates of each path for each individual. Names are id_contemp and id_lagged.
 \item{SEs} Directory, contains individual-level standard errors for each path for each indiivdual. Names are id_contemp and id_lagged.
 \item{plots} Direcotry, contains individual-level plots. Red paths represent positive weights and blue paths represent negative weights.
}
}
\examples{
\dontrun{
paths <- 'V2 ~ V1
          V3 ~ V4lag'

gimme(data     = "C:/data100",
      sep      = ",",
      header   = FALSE,
      out      = "C:/data100_gimme_out",
      ar       = TRUE,
      plot     = TRUE,
      paths    = paths,
      subgroup = FALSE)
 }
}
\author{
Stephanie Lane
}
\references{
Gates, K.M. & Molenaar, P.C.M. (2012). Group search algorithm recovers effective connectivity maps
for individuals in homogeneous and heterogeneous samples. NeuroImage, 63, 310-319.
}
\keyword{gimme}

