% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/downloadGimms.R
\docType{methods}
\name{downloadGimms}
\alias{downloadGimms}
\alias{downloadGimms,character-method}
\alias{downloadGimms,missing-method}
\alias{downloadGimms,numeric-method}
\title{Download GIMMS 3G data}
\usage{
\S4method{downloadGimms}{numeric}(x, y, dsn = getwd(), overwrite = FALSE,
  quiet = TRUE, ...)

\S4method{downloadGimms}{character}(x, dsn = getwd(), overwrite = FALSE,
  quiet = TRUE, ...)

\S4method{downloadGimms}{missing}(dsn = getwd(), overwrite = FALSE,
  quiet = TRUE, ...)
}
\arguments{
\item{x}{If 'numeric', start year for download (e.g. 2000). If 'character',
a vector of full online filepath(s) to download, typically returned from
\code{\link{updateInventory}}. If not supplied, download will start from the
first year available.}

\item{y}{'numeric'. End year for download. If not supplied, download will
stop at the last year available.}

\item{dsn}{'character'. Destination folder for file download. If not supplied,
all downloaded files will be stored in the current working directory.}

\item{overwrite}{Logical. If \code{TRUE}, already downloaded files in 'dsn'
will be overwritten.}

\item{quiet}{Logical. If \code{TRUE}, information sent to the console is
reduced.}

\item{...}{Further arguments passed on to \code{\link{download.file}}.}
}
\value{
A vector of filepaths.
}
\description{
Download GIMMS 3G binary data for a given time span from NASA FTP server
(\url{http://ecocast.arc.nasa.gov/data/pub/gimms/3g.v0/}).
}
\examples{
\dontrun{
## Download GIMMS NDVI3g binary data from 2000-2005 (this might take some time...)
gimms_files <- downloadGimms(x = 2000, y = 2005,
                             dsn = paste0(getwd(), "/data"))
gimms_files[1:10]
}
}
\author{
Florian Detsch
}
\seealso{
\code{\link{download.file}}
}

