% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco_get_education.R
\name{gisco_get_education}
\alias{gisco_get_education}
\title{Get locations of education services in Europe}
\source{
\url{https://ec.europa.eu/eurostat/web/gisco/geodata/basic-services}
}
\usage{
gisco_get_education(
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  country = NULL
)
}
\arguments{
\item{cache}{A logical whether to do caching. Default is \code{TRUE}. See
\strong{About caching}.}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source
\code{.geojson} file.}

\item{cache_dir}{A path to a cache directory. See \strong{About caching}.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}

\item{country}{Optional. A character vector of country codes. It could be
either a vector of country names, a vector of ISO3 country codes or a
vector of Eurostat country codes. Mixed types (as \code{c("Italy","ES","FRA")})
would not work. See also \code{\link[countrycode:countrycode]{countrycode::countrycode()}}.}
}
\value{
A \code{POINT} \code{\link[sf:sf]{sf}} object.
}
\description{
The dataset contains information on main education services by Member States.
}
\details{
Files are distributed on EPSG:4326. Metadata available on
\url{https://gisco-services.ec.europa.eu/pub/education/metadata.pdf}.
}
\section{About caching}{
You can set your \code{cache_dir} with \code{\link[=gisco_set_cache_dir]{gisco_set_cache_dir()}}.

Sometimes cached files may be corrupt. On that case, try re-downloading
the data setting \code{update_cache = TRUE}.

If you experience any problem on download, try to download the
corresponding \code{.geojson} file by any other method and save it on your
\code{cache_dir}. Use the option \code{verbose = TRUE} for debugging the API query.

For a complete list of files available check \link{gisco_db}.
}

\examples{
\dontshow{if (gisco_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{

edu_BEL <- gisco_get_education(country = "Belgium")

# Plot if downloaded
if (nrow(edu_BEL) > 3) {
  library(ggplot2)
  ggplot(edu_BEL) +
    geom_sf(shape = 21, size = 0.15)
}
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=gisco_get_countries]{gisco_get_countries()}}

Other infrastructure: 
\code{\link{gisco_get_airports}()},
\code{\link{gisco_get_healthcare}()}
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
\concept{infrastructure}
