% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repository.r
\docType{methods}
\name{lookup}
\alias{lookup}
\alias{lookup,git_repository,character-method}
\title{Lookup}
\usage{
lookup(repo, sha)

\S4method{lookup}{git_repository,character}(repo, sha)
}
\arguments{
\item{repo}{The repository.}

\item{sha}{The identity of the object to lookup. Must be 4 to 40
characters long.}
}
\value{
a \code{git_blob} or \code{git_commit} or \code{git_tag}
or \code{git_tree} object
}
\description{
Lookup one object in a repository.
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user and commit a file
config(repo, user.name="Alice", user.email="alice@example.org")
writeLines("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
           file.path(path, "example.txt"))
add(repo, "example.txt")
commit_1 <- commit(repo, "First commit message")

## Create tag
tag(repo, "Tagname", "Tag message")

## First, get SHAs to lookup in the repository
sha_commit <- commit_1@sha
sha_tree <- tree(commit_1)@sha
sha_blob <- tree(commit_1)["example.txt"]@sha
sha_tag <- tags(repo)[[1]]@sha

## SHAs
sha_commit
sha_tree
sha_blob
sha_tag

## Lookup objects
lookup(repo, sha_commit)
lookup(repo, sha_tree)
lookup(repo, sha_blob)
lookup(repo, sha_tag)

## Lookup objects, using only the first seven characters
lookup(repo, substr(sha_commit, 1, 7))
lookup(repo, substr(sha_tree, 1, 7))
lookup(repo, substr(sha_blob, 1, 7))
lookup(repo, substr(sha_tag, 1, 7))
}
}
\keyword{methods}

