% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git_down.R
\name{git_down}
\alias{git_down}
\title{Turns the active branch history of git into a bookdown.}
\usage{
git_down(
  repo = ".",
  book_path = "gitdown",
  open = TRUE,
  author = "John Doe",
  pattern = c(Issues = "#[[:digit:]]+"),
  pattern.table = NULL,
  ref = "master",
  ...
)
}
\arguments{
\item{repo}{The path to a repository. Default is \code{.}}

\item{book_path}{The path to the bookdown output. Default is \code{"gitdown"}.}

\item{open}{Should the bookdown be opened once compiled? Default is TRUE.}

\item{author}{Author of the bookdown}

\item{pattern}{Named vector with regex pattern to expose commits, like \verb{c("Issues" = "#\[\[:digit:\]\]")} for issues}

\item{pattern.table}{data.frame with two columns: pattern and description of the pattern.
This is used as correspondence table to add some names to existing patterns.}

\item{ref}{the name of the branch, by default master}

\item{...}{Other parameters to pass to \code{\link[rmarkdown:render]{rmarkdown::render()}}}
}
\value{
Path of the HTML gitbook saved in the repo/book_path directory.
}
\description{
Read all commit messages of your local git repository and
sort them according to tags or specific text pattern into chapters of
a HTML book using 'bookdown'.
Each chapter is a group of commits. The first page gives a summary of all the groups.
}
\examples{
repo <- fake_repo()
res <- git_down(repo, pattern = c("Tickets" = "ticket[[:digit:]]+", "Issues" = "#[[:digit:]]+"),
open = FALSE)
\dontrun{
# Open the book
  browseURL(res)
}
# With table of correspondence
pattern.table <- data.frame(number = c("#2", "#1"),
  title = c("#2 A second issue to illustrate a blog post",
                       "#1 An example of issue"))
res <- git_down(repo, pattern = c("Issues" = "#[[:digit:]]+"),
  pattern.table = pattern.table, open = FALSE)
\dontrun{
# Open the book
  browseURL(res)
}
}
