% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwreg.R
\name{get_bounded_datasets}
\alias{get_bounded_datasets}
\title{Access datasets from bounded response regression packages}
\usage{
get_bounded_datasets(dataset_name, package = NULL, attach_to_namespace = FALSE)
}
\arguments{
\item{dataset_name}{A character string. The name of the dataset to retrieve.}

\item{package}{A character string. The package containing the dataset. Must be one of
"betareg" or "simplexreg". If NULL (default), the function searches both packages.}

\item{attach_to_namespace}{Logical. If TRUE, the dataset will be attached to
the calling environment. Default is FALSE.}
}
\value{
A data frame containing the requested dataset.
}
\description{
This function provides direct access to datasets from the 'betareg' and 'simplexreg'
packages without copying them to your project files. It dynamically loads
the requested dataset from the respective package's namespace.
}
\examples{
\dontrun{

# Example 1: Beta regression on ReadingSkills data
# ------------------------------------------------

# This example analyzes factors affecting reading accuracy in children with dyslexia.

# Load ReadingSkills data
reading_data <- get_bounded_datasets("ReadingSkills")

# Fit beta regression model
reading_model <- gkwreg(
  accuracy ~ dyslexia + iq,
  data = reading_data,
  family = "beta",
  link = list(gamma = "log", delta = "logit")
)

summary(reading_model)

# Example 2: Kumaraswamy regression on FoodExpenditure data
# --------------------------------------------------------
# This example models the proportion of income spent on food.

# Load FoodExpenditure data
food_data <- get_bounded_datasets("FoodExpenditure")
food_data$y <- food_data$food / food_data$income

# Fit Kumaraswamy regression model
food_model <- gkwreg(
  y ~ persons,
  data = food_data,
  family = "kw",
  link = list(alpha = "log", beta = "log")
)

summary(food_model)

# Example 3: Exponential Kumaraswamy regression on retinal data
# ------------------------------------------------------------
# This example analyzes the decay of intraocular gas in retinal surgeries.

# Load retinal data
retinal_data <- get_bounded_datasets("retinal", package = "simplexreg")

# Fit a Kumaraswamy - Kumaraswamy model
retinal_model <- gkwreg(
  Gas ~ LogT2 | Level | Time,
  data = retinal_data,
  family = "ekw"
)

summary(retinal_model)
}

}
\seealso{
\code{\link{list_bounded_datasets}}
}
