% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalZdensity.R
\name{evalZdensity}
\alias{evalZdensity}
\title{Evaluate the (negative log) unnormalized marginal z density in a given
model.}
\usage{
evalZdensity(
  config,
  object,
  zValues,
  conditional = FALSE,
  debug = FALSE,
  higherOrderCorrection = FALSE
)
}
\arguments{
\item{config}{the configuration of a single \code{GlmBayesMfp} model. The
null model is not allowed. It is interpreted in the context of
\code{object}.}

\item{object}{the \code{\link{GlmBayesMfp}} object}

\item{zValues}{the z values}

\item{conditional}{return the approximate *conditional* density f(y | z)?
(not default)}

\item{debug}{print debugging information? (not default)}

\item{higherOrderCorrection}{should a higher-order correction of the
Laplace approximation be used? (not default)}
}
\value{
the negative log marginal unnormalized density values at the
\code{zValues}. (Note the words \dQuote{negative}, \dQuote{log}, and
\dQuote{unnormalized} !!!)
}
\description{
Based on the result list from \code{\link{glmBayesMfp}}, for the first model
in the list, the marginal z density can be evaluated.
}
\keyword{internal}
