% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.R
\name{ss_glmaag}
\alias{ss_glmaag}
\title{Stability selection for glmaag}
\usage{
ss_glmaag(y, x, L, nfolds = 5, subn, nsam = 100, beta = 0.15,
  gam = 1, tune = F, est = T, lam1, lam2, w0, adaptl1 = T,
  adaptl2 = T, pind, intercept = T, standardize = T,
  maxiter = 10000, cri = 0.001, fam = "Gaussian", measdev = T,
  type1se = T, parallel = F)
}
\arguments{
\item{y}{outcome}

\item{x}{predictors matrix}

\item{L}{Laplacian matrix for the first network}

\item{nfolds}{number of folds used in cross validation to estimate the l1 weights or network tuning, default to be five}

\item{subn}{number of samples in each subset, default to be n/2 if n<400 and 10sqrt(10) if n>400}

\item{nsam}{number of subsets, default to be 100}

\item{beta}{the cut off for instability score}

\item{gam}{The power of weights of l1 penalty, default to be ones}

\item{tune}{whether to tune the input network with estimated network or identity matrix, ignored if no input network}

\item{est}{when there is no input network whether to use estimated network or identiy matrix (elastic net) or mixed the network with estimated network or identity matrix, default to be estimated network}

\item{lam1}{The tuning parameters for l1 penalty. If not defined, searched by default}

\item{lam2}{The tuning parameters for quadratic penalty. If not defined, searched by default}

\item{w0}{Weights for l1 penalty. If not defined, estimated via quadratic penalyzed regression}

\item{adaptl1}{whether to adapt the l1 penalty, default to be TRUE}

\item{adaptl2}{whether to adapt the sign for quadratic penalty, default to be TRUE}

\item{pind}{indicator vector whether to put l1 penalty on the feature, 1 means penalyzed while 0 means not penalyzed, default to be all ones (all penalyzed)}

\item{intercept}{whether to include intercept. Ignore for Cox regression}

\item{standardize}{whether to standardize predictors}

\item{maxiter}{maximum number of iterations, default to be 500}

\item{cri}{stoppint criterion, default to be 0.001}

\item{fam}{family for the outcome, can be "Gaussian", "Logistic", and "Cox"}

\item{measdev}{Whether to use deviance to tune when estimate l1 weight and network sign, default to be deviance. If not, use mean absolue error, area under ROC curve, or concordance index for Gaussian, Logistic, and Cox}

\item{type1se}{whether to use one standard error or maximum rule for l1 weight estimation and network sign, default to be one standard error rule}

\item{parallel}{whether to do parallel computing at each subset, need to set up parallel first, default to be FALSE}
}
\value{
\item{input}{input matrix for predictors}

\item{lambda1}{searching sequence for l1 penalty parameters}

\item{lamdba2}{searching sequence for quadratic penalty parameters}

\item{lambda1_ss}{optimal l1 parameter}

\item{lambda2_ss}{optimal quadratic parameter}

\item{n_ss}{number of parameters obtained by the optimal model}

\item{ssm}{instability score paths}

\item{ssf}{selection probability paths}

\item{intercept_ss}{intercept estimated by the optimal model}

\item{coef_ss}{coefficients estimated by the optimal model}

\item{fam}{the family of the outcome}
}
\description{
Do stability selection for glmaag
}
\examples{
data(sampledata)
data(L0)
y <- sampledata$Y_Gau
x <- sampledata[, 4:6]
mod <- ss_glmaag(y, x, L0[seq_len(3), seq_len(3)], nsam = 3)
}
\references{
Meinshausen, N., & B{"u}hlmann, P. (2010). Stability selection. Journal of the Royal Statistical Society: Series B (Statistical Methodology), 72(4), 417-473.

Liu, H., Roeder, K., & Wasserman, L. (2010). Stability approach to regularization selection (stars) for high dimensional graphical models. In Advances in neural information processing systems (pp. 1432-1440).
}
