% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family.R
\name{nbinom2}
\alias{nbinom2}
\alias{family_glmmTMB}
\alias{nbinom1}
\alias{compois}
\alias{genpois}
\alias{truncated_poisson}
\alias{truncated_nbinom2}
\alias{truncated_nbinom1}
\alias{betar}
\alias{betabinomial}
\alias{tweedie}
\title{Family functions for glmmTMB}
\usage{
nbinom2(link = "log")

nbinom1(link = "log")

compois(link = "log")

genpois(link = "log")

truncated_poisson(link = "log")

truncated_nbinom2(link = "log")

truncated_nbinom1(link = "log")

betar(link = "logit")

betabinomial(link = "logit")

tweedie(link = "log")
}
\arguments{
\item{link}{(character) link function ("log", "logit", "probit", "inverse", "cloglog", or "identity")}
}
\value{
returns a list with (at least) components
\item{family}{length-1 character vector giving the family name}
\item{link}{length-1 character vector specifying the link function}
\item{variance}{a function of either 1 (mean) or 2 (mean and dispersion
parameter) arguments giving the predicted variance}
}
\description{
Family functions for glmmTMB
}
\details{
\describe{
     \item{nbinom2}{has a variance that increases quadratically with the mean (Hardin & Hilbe 2007)}
     \item{nbinom1}{has a variance that increases linearly with the mean (Hardin & Hilbe 2007)}
     \item{compois}{is the Conway-Maxwell Poisson parameterized with the exact mean
       which differs from the COMPoissonReg package (Sellers & Lotze 2015)}
     \item{genpois}{is the generalized Poisson distribution}
     \item{beta}{follows the parameterization of Ferrari and Cribari-Neto (2004) and the \code{betareg} package}
}
}
\references{
\itemize{
\item Ferrari SLP, Cribari-Neto F (2004). "Beta Regression for Modelling Rates and Proportions." \emph{J. Appl. Stat.}  31(7), 799-815.
\item Hardin JW & Hilbe JM (2007). "Generalized linear models and extensions." Stata press.
\item Sellers K & Lotze T (2015). "COMPoissonReg: Conway-Maxwell Poisson (COM-Poisson) Regression". R package version 0.3.5. https://CRAN.R-project.org/package=COMPoissonReg
}
}
